/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether a resource is a member of a group in the identity store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupMembershipExistenceResult implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupMembershipExistenceResult.Builder, GroupMembershipExistenceResult> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(GroupMembershipExistenceResult::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.<MemberId> builder(MarshallingType.SDK_POJO)
            .memberName("MemberId").getter(getter(GroupMembershipExistenceResult::memberId)).setter(setter(Builder::memberId))
            .constructor(MemberId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<Boolean> MEMBERSHIP_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MembershipExists").getter(getter(GroupMembershipExistenceResult::membershipExists))
            .setter(setter(Builder::membershipExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipExists").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            MEMBER_ID_FIELD, MEMBERSHIP_EXISTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final MemberId memberId;

    private final Boolean membershipExists;

    private GroupMembershipExistenceResult(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.memberId = builder.memberId;
        this.membershipExists = builder.membershipExists;
    }

    /**
     * <p>
     * The identifier for a group in the identity store.
     * </p>
     * 
     * @return The identifier for a group in the identity store.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     * 
     * @return An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
     *         specific identifier for a user indicates that the user is a member of the group.
     */
    public final MemberId memberId() {
        return memberId;
    }

    /**
     * <p>
     * Indicates whether a membership relation exists or not.
     * </p>
     * 
     * @return Indicates whether a membership relation exists or not.
     */
    public final Boolean membershipExists() {
        return membershipExists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipExists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupMembershipExistenceResult)) {
            return false;
        }
        GroupMembershipExistenceResult other = (GroupMembershipExistenceResult) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(memberId(), other.memberId())
                && Objects.equals(membershipExists(), other.membershipExists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupMembershipExistenceResult").add("GroupId", groupId()).add("MemberId", memberId())
                .add("MembershipExists", membershipExists() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "MembershipExists":
            return Optional.ofNullable(clazz.cast(membershipExists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupMembershipExistenceResult, T> g) {
        return obj -> g.apply((GroupMembershipExistenceResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupMembershipExistenceResult> {
        /**
         * <p>
         * The identifier for a group in the identity store.
         * </p>
         * 
         * @param groupId
         *        The identifier for a group in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         * specific identifier for a user indicates that the user is a member of the group.
         * </p>
         * 
         * @param memberId
         *        An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         *        specific identifier for a user indicates that the user is a member of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(MemberId memberId);

        /**
         * <p>
         * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         * specific identifier for a user indicates that the user is a member of the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberId.Builder} avoiding the need to
         * create one manually via {@link MemberId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemberId.Builder#build()} is called immediately and its result is
         * passed to {@link #memberId(MemberId)}.
         * 
         * @param memberId
         *        a consumer that will call methods on {@link MemberId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberId(MemberId)
         */
        default Builder memberId(Consumer<MemberId.Builder> memberId) {
            return memberId(MemberId.builder().applyMutation(memberId).build());
        }

        /**
         * <p>
         * Indicates whether a membership relation exists or not.
         * </p>
         * 
         * @param membershipExists
         *        Indicates whether a membership relation exists or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipExists(Boolean membershipExists);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private MemberId memberId;

        private Boolean membershipExists;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupMembershipExistenceResult model) {
            groupId(model.groupId);
            memberId(model.memberId);
            membershipExists(model.membershipExists);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return memberId != null ? memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public final Boolean getMembershipExists() {
            return membershipExists;
        }

        public final void setMembershipExists(Boolean membershipExists) {
            this.membershipExists = membershipExists;
        }

        @Override
        public final Builder membershipExists(Boolean membershipExists) {
            this.membershipExists = membershipExists;
            return this;
        }

        @Override
        public GroupMembershipExistenceResult build() {
            return new GroupMembershipExistenceResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
