/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.identitystore.model.CreateGroupRequest;
import software.amazon.awssdk.services.identitystore.model.CreateGroupResponse;
import software.amazon.awssdk.services.identitystore.model.CreateUserRequest;
import software.amazon.awssdk.services.identitystore.model.CreateUserResponse;
import software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.identitystore.model.DeleteGroupRequest;
import software.amazon.awssdk.services.identitystore.model.DeleteGroupResponse;
import software.amazon.awssdk.services.identitystore.model.DeleteUserRequest;
import software.amazon.awssdk.services.identitystore.model.DeleteUserResponse;
import software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipRequest;
import software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipResponse;
import software.amazon.awssdk.services.identitystore.model.DescribeGroupRequest;
import software.amazon.awssdk.services.identitystore.model.DescribeGroupResponse;
import software.amazon.awssdk.services.identitystore.model.DescribeUserRequest;
import software.amazon.awssdk.services.identitystore.model.DescribeUserResponse;
import software.amazon.awssdk.services.identitystore.model.GetGroupIdRequest;
import software.amazon.awssdk.services.identitystore.model.GetGroupIdResponse;
import software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdRequest;
import software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdResponse;
import software.amazon.awssdk.services.identitystore.model.GetUserIdRequest;
import software.amazon.awssdk.services.identitystore.model.GetUserIdResponse;
import software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsRequest;
import software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsResponse;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.identitystore.model.ListGroupsRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupsResponse;
import software.amazon.awssdk.services.identitystore.model.ListUsersRequest;
import software.amazon.awssdk.services.identitystore.model.ListUsersResponse;
import software.amazon.awssdk.services.identitystore.model.UpdateGroupRequest;
import software.amazon.awssdk.services.identitystore.model.UpdateGroupResponse;
import software.amazon.awssdk.services.identitystore.model.UpdateUserRequest;
import software.amazon.awssdk.services.identitystore.model.UpdateUserResponse;
import software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsForMemberPublisher;
import software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsPublisher;
import software.amazon.awssdk.services.identitystore.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.identitystore.paginators.ListUsersPublisher;

/**
 * Service client for accessing IdentityStore asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Identity Store service used by AWS IAM Identity Center (successor to AWS Single Sign-On) provides a single place
 * to retrieve all of your identities (users and groups). For more information, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">IAM Identity Center User Guide</a>.
 * </p>
 * 
 * <pre>
 * <code> &lt;note&gt; &lt;p&gt;Although AWS Single Sign-On was renamed, the &lt;code&gt;sso&lt;/code&gt; and &lt;code&gt;identitystore&lt;/code&gt; API namespaces will continue to retain their original name for backward compatibility purposes. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed&quot;&gt;IAM Identity Center rename&lt;/a&gt;.&lt;/p&gt; &lt;/note&gt; &lt;p&gt;This reference guide describes the identity store operations that you can call programatically and includes detailed information about data types and errors.&lt;/p&gt; </code>
 * </pre>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IdentitystoreAsyncClient extends AwsClient {
    String SERVICE_NAME = "identitystore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "identitystore";

    /**
     * <p>
     * Creates a group within the specified identity store.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group within the specified identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates a relationship between a member and a group. The following identifiers must be specified:
     * <code>GroupId</code>, <code>IdentityStoreId</code>, and <code>MemberId</code>.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.CreateGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            CreateGroupMembershipRequest createGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a relationship between a member and a group. The following identifiers must be specified:
     * <code>GroupId</code>, <code>IdentityStoreId</code>, and <code>MemberId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupMembershipRequest#builder()}
     * </p>
     *
     * @param createGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.CreateGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            Consumer<CreateGroupMembershipRequest.Builder> createGroupMembershipRequest) {
        return createGroupMembership(CreateGroupMembershipRequest.builder().applyMutation(createGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Creates a user within the specified identity store.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user within the specified identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Delete a group within an identity store given <code>GroupId</code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a group within an identity store given <code>GroupId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Delete a membership within a group given <code>MembershipId</code>.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DeleteGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            DeleteGroupMembershipRequest deleteGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a membership within a group given <code>MembershipId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGroupMembershipRequest#builder()}
     * </p>
     *
     * @param deleteGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DeleteGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            Consumer<DeleteGroupMembershipRequest.Builder> deleteGroupMembershipRequest) {
        return deleteGroupMembership(DeleteGroupMembershipRequest.builder().applyMutation(deleteGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes a user within an identity store given <code>UserId</code>.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user within an identity store given <code>UserId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Retrieves the group metadata and attributes from <code>GroupId</code> in an identity store.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the group metadata and attributes from <code>GroupId</code> in an identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest) {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves membership metadata and attributes from <code>MembershipId</code> in an identity store.
     * </p>
     *
     * @param describeGroupMembershipRequest
     * @return A Java Future containing the result of the DescribeGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DescribeGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGroupMembershipResponse> describeGroupMembership(
            DescribeGroupMembershipRequest describeGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves membership metadata and attributes from <code>MembershipId</code> in an identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGroupMembershipRequest#builder()}
     * </p>
     *
     * @param describeGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DescribeGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGroupMembershipResponse> describeGroupMembership(
            Consumer<DescribeGroupMembershipRequest.Builder> describeGroupMembershipRequest) {
        return describeGroupMembership(DescribeGroupMembershipRequest.builder().applyMutation(describeGroupMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the user metadata and attributes from the <code>UserId</code> in an identity store.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the user metadata and attributes from the <code>UserId</code> in an identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Retrieves <code>GroupId</code> in an identity store.
     * </p>
     *
     * @param getGroupIdRequest
     * @return A Java Future containing the result of the GetGroupId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.GetGroupId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupId" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupIdResponse> getGroupId(GetGroupIdRequest getGroupIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves <code>GroupId</code> in an identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupIdRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupIdRequest#builder()}
     * </p>
     *
     * @param getGroupIdRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupIdRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroupId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.GetGroupId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupId" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupIdResponse> getGroupId(Consumer<GetGroupIdRequest.Builder> getGroupIdRequest) {
        return getGroupId(GetGroupIdRequest.builder().applyMutation(getGroupIdRequest).build());
    }

    /**
     * <p>
     * Retrieves the <code>MembershipId</code> in an identity store.
     * </p>
     *
     * @param getGroupMembershipIdRequest
     * @return A Java Future containing the result of the GetGroupMembershipId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.GetGroupMembershipId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupMembershipId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGroupMembershipIdResponse> getGroupMembershipId(
            GetGroupMembershipIdRequest getGroupMembershipIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <code>MembershipId</code> in an identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupMembershipIdRequest.Builder} avoiding the
     * need to create one manually via {@link GetGroupMembershipIdRequest#builder()}
     * </p>
     *
     * @param getGroupMembershipIdRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupMembershipIdRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGroupMembershipId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.GetGroupMembershipId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupMembershipId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGroupMembershipIdResponse> getGroupMembershipId(
            Consumer<GetGroupMembershipIdRequest.Builder> getGroupMembershipIdRequest) {
        return getGroupMembershipId(GetGroupMembershipIdRequest.builder().applyMutation(getGroupMembershipIdRequest).build());
    }

    /**
     * <p>
     * Retrieves the <code>UserId</code> in an identity store.
     * </p>
     *
     * @param getUserIdRequest
     * @return A Java Future containing the result of the GetUserId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.GetUserId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetUserId" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserIdResponse> getUserId(GetUserIdRequest getUserIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <code>UserId</code> in an identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserIdRequest.Builder} avoiding the need to
     * create one manually via {@link GetUserIdRequest#builder()}
     * </p>
     *
     * @param getUserIdRequest
     *        A {@link Consumer} that will call methods on {@link GetUserIdRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUserId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.GetUserId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetUserId" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserIdResponse> getUserId(Consumer<GetUserIdRequest.Builder> getUserIdRequest) {
        return getUserId(GetUserIdRequest.builder().applyMutation(getUserIdRequest).build());
    }

    /**
     * <p>
     * Checks the user's membership in all requested groups and returns if the member exists in all queried groups.
     * </p>
     *
     * @param isMemberInGroupsRequest
     * @return A Java Future containing the result of the IsMemberInGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.IsMemberInGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/IsMemberInGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<IsMemberInGroupsResponse> isMemberInGroups(IsMemberInGroupsRequest isMemberInGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the user's membership in all requested groups and returns if the member exists in all queried groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IsMemberInGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link IsMemberInGroupsRequest#builder()}
     * </p>
     *
     * @param isMemberInGroupsRequest
     *        A {@link Consumer} that will call methods on {@link IsMemberInGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the IsMemberInGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.IsMemberInGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/IsMemberInGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<IsMemberInGroupsResponse> isMemberInGroups(
            Consumer<IsMemberInGroupsRequest.Builder> isMemberInGroupsRequest) {
        return isMemberInGroups(IsMemberInGroupsRequest.builder().applyMutation(isMemberInGroupsRequest).build());
    }

    /**
     * <p>
     * For the specified group in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            ListGroupMembershipsRequest listGroupMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified group in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupMembershipsRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            Consumer<ListGroupMembershipsRequest.Builder> listGroupMembershipsRequest) {
        return listGroupMemberships(ListGroupMembershipsRequest.builder().applyMutation(listGroupMembershipsRequest).build());
    }

    /**
     * <p>
     * For the specified member in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     *
     * @param listGroupMembershipsForMemberRequest
     * @return A Java Future containing the result of the ListGroupMembershipsForMember operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMembershipsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsForMemberResponse> listGroupMembershipsForMember(
            ListGroupMembershipsForMemberRequest listGroupMembershipsForMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified member in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsForMemberRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupMembershipsForMemberRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsForMemberRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsForMemberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGroupMembershipsForMember operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMembershipsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsForMemberResponse> listGroupMembershipsForMember(
            Consumer<ListGroupMembershipsForMemberRequest.Builder> listGroupMembershipsForMemberRequest) {
        return listGroupMembershipsForMember(ListGroupMembershipsForMemberRequest.builder()
                .applyMutation(listGroupMembershipsForMemberRequest).build());
    }

    /**
     * <p>
     * For the specified member in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembershipsForMember(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsForMemberPublisher publisher = client.listGroupMembershipsForMemberPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsForMemberPublisher publisher = client.listGroupMembershipsForMemberPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembershipsForMember(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupMembershipsForMemberRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMembershipsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsForMemberPublisher listGroupMembershipsForMemberPaginator(
            ListGroupMembershipsForMemberRequest listGroupMembershipsForMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified member in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembershipsForMember(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsForMemberPublisher publisher = client.listGroupMembershipsForMemberPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsForMemberPublisher publisher = client.listGroupMembershipsForMemberPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembershipsForMember(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsForMemberRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupMembershipsForMemberRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsForMemberRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsForMemberRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMembershipsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsForMemberPublisher listGroupMembershipsForMemberPaginator(
            Consumer<ListGroupMembershipsForMemberRequest.Builder> listGroupMembershipsForMemberRequest) {
        return listGroupMembershipsForMemberPaginator(ListGroupMembershipsForMemberRequest.builder()
                .applyMutation(listGroupMembershipsForMemberRequest).build());
    }

    /**
     * <p>
     * For the specified group in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMemberships(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsPublisher publisher = client.listGroupMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsPublisher publisher = client.listGroupMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMemberships(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsPublisher listGroupMembershipsPaginator(ListGroupMembershipsRequest listGroupMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified group in the specified identity store, returns the list of all <code>GroupMembership</code>
     * objects and returns results in paginated form.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMemberships(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsPublisher publisher = client.listGroupMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupMembershipsPublisher publisher = client.listGroupMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMemberships(software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupMembershipsRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroupMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsPublisher listGroupMembershipsPaginator(
            Consumer<ListGroupMembershipsRequest.Builder> listGroupMembershipsRequest) {
        return listGroupMembershipsPaginator(ListGroupMembershipsRequest.builder().applyMutation(listGroupMembershipsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all groups in the identity store. Returns a paginated list of complete <code>Group</code> objects.
     * Filtering for a <code>Group</code> by the <code>DisplayName</code> attribute is deprecated. Instead, use the
     * <code>GetGroupId</code> API action.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all groups in the identity store. Returns a paginated list of complete <code>Group</code> objects.
     * Filtering for a <code>Group</code> by the <code>DisplayName</code> attribute is deprecated. Instead, use the
     * <code>GetGroupId</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all groups in the identity store. Returns a paginated list of complete <code>Group</code> objects.
     * Filtering for a <code>Group</code> by the <code>DisplayName</code> attribute is deprecated. Instead, use the
     * <code>GetGroupId</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.identitystore.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.identitystore.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all groups in the identity store. Returns a paginated list of complete <code>Group</code> objects.
     * Filtering for a <code>Group</code> by the <code>DisplayName</code> attribute is deprecated. Instead, use the
     * <code>GetGroupId</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.identitystore.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.identitystore.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all users in the identity store. Returns a paginated list of complete <code>User</code> objects. Filtering
     * for a <code>User</code> by the <code>UserName</code> attribute is deprecated. Instead, use the
     * <code>GetUserId</code> API action.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all users in the identity store. Returns a paginated list of complete <code>User</code> objects. Filtering
     * for a <code>User</code> by the <code>UserName</code> attribute is deprecated. Instead, use the
     * <code>GetUserId</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists all users in the identity store. Returns a paginated list of complete <code>User</code> objects. Filtering
     * for a <code>User</code> by the <code>UserName</code> attribute is deprecated. Instead, use the
     * <code>GetUserId</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.identitystore.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.identitystore.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all users in the identity store. Returns a paginated list of complete <code>User</code> objects. Filtering
     * for a <code>User</code> by the <code>UserName</code> attribute is deprecated. Instead, use the
     * <code>GetUserId</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.identitystore.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.identitystore.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.identitystore.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.identitystore.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.identitystore.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * For the specified group in the specified identity store, updates the group metadata and attributes.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified group in the specified identity store, updates the group metadata and attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * For the specified user in the specified identity store, updates the user metadata and attributes.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified user in the specified identity store, updates the user metadata and attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ServiceQuotaExceededException The request would cause the number of users or groups in the identity
     *         store to exceed the maximum allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IdentitystoreException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IdentitystoreAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    @Override
    default IdentitystoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IdentitystoreAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IdentitystoreAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IdentitystoreAsyncClient}.
     */
    static IdentitystoreAsyncClientBuilder builder() {
        return new DefaultIdentitystoreAsyncClientBuilder();
    }
}
