/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConflictExceptionReason {
    UNIQUENESS_CONSTRAINT_VIOLATION("UNIQUENESS_CONSTRAINT_VIOLATION"),
    CONCURRENT_MODIFICATION("CONCURRENT_MODIFICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConflictExceptionReason> VALUE_MAP;
    private final String value;

    private ConflictExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictExceptionReason> knownValues() {
        EnumSet<ConflictExceptionReason> knownValues = EnumSet.allOf(ConflictExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConflictExceptionReason.class, ConflictExceptionReason::toString);
    }
}

