/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.identitystore.IdentitystoreAsyncClient;
import software.amazon.awssdk.services.identitystore.model.GroupMembership;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse;

public class ListGroupMembershipsPublisher
implements SdkPublisher<ListGroupMembershipsResponse> {
    private final IdentitystoreAsyncClient client;
    private final ListGroupMembershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupMembershipsPublisher(IdentitystoreAsyncClient client, ListGroupMembershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupMembershipsPublisher(IdentitystoreAsyncClient client, ListGroupMembershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupMembershipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupMembershipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupMembership> groupMemberships() {
        Function<ListGroupMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupMemberships() != null) {
                return response.groupMemberships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupMembershipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupMembershipsResponseFetcher
    implements AsyncPageFetcher<ListGroupMembershipsResponse> {
        private ListGroupMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupMembershipsResponse> nextPage(ListGroupMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembershipsPublisher.this.client.listGroupMemberships(ListGroupMembershipsPublisher.this.firstRequest);
            }
            return ListGroupMembershipsPublisher.this.client.listGroupMemberships((ListGroupMembershipsRequest)((Object)ListGroupMembershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

