/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This request cannot be completed for one of the following reasons:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
 * conflict before retrying this request.
 * </p>
 * </li>
 * <li>
 * <p>
 * The requested resource was being concurrently modified by another request.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends IdentitystoreException implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ConflictException::requestIdValue)).setter(setter(Builder::requestIdValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ConflictException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REQUEST_ID_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String requestId;

    private final String reason;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @return The identifier for each request. This value is a globally unique ID that is generated by the identity
     *         store service for each sent request, and is then returned inside the exception if the request fails.
     */
    public String requestIdValue() {
        return requestId;
    }

    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ConflictExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li>
     * @see ConflictExceptionReason
     */
    public ConflictExceptionReason reason() {
        return ConflictExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ConflictExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li>
     * @see ConflictExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, IdentitystoreException.Builder {
        /**
         * <p>
         * The identifier for each request. This value is a globally unique ID that is generated by the identity store
         * service for each sent request, and is then returned inside the exception if the request fails.
         * </p>
         * 
         * @param requestId
         *        The identifier for each request. This value is a globally unique ID that is generated by the identity
         *        store service for each sent request, and is then returned inside the exception if the request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdValue(String requestId);

        /**
         * <p>
         * This request cannot be completed for one of the following reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve
         * the conflict before retrying this request.
         * </p>
         * </li>
         * <li>
         * <p>
         * The requested resource was being concurrently modified by another request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        This request cannot be completed for one of the following reasons:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Performing the requested operation would violate an existing uniqueness claim in the identity store.
         *        Resolve the conflict before retrying this request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The requested resource was being concurrently modified by another request.
         *        </p>
         *        </li>
         * @see ConflictExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * This request cannot be completed for one of the following reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve
         * the conflict before retrying this request.
         * </p>
         * </li>
         * <li>
         * <p>
         * The requested resource was being concurrently modified by another request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        This request cannot be completed for one of the following reasons:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Performing the requested operation would violate an existing uniqueness claim in the identity store.
         *        Resolve the conflict before retrying this request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The requested resource was being concurrently modified by another request.
         *        </p>
         *        </li>
         * @see ConflictExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionReason
         */
        Builder reason(ConflictExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends IdentitystoreException.BuilderImpl implements Builder {
        private String requestId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            requestIdValue(model.requestId);
            reason(model.reason);
        }

        public final String getRequestIdValue() {
            return requestId;
        }

        public final void setRequestIdValue(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestIdValue(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ConflictExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
