/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGroupResponse extends IdentitystoreResponse implements
        ToCopyableBuilder<DescribeGroupResponse.Builder, DescribeGroupResponse> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(DescribeGroupResponse::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(DescribeGroupResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<List<ExternalId>> EXTERNAL_IDS_FIELD = SdkField
            .<List<ExternalId>> builder(MarshallingType.LIST)
            .memberName("ExternalIds")
            .getter(getter(DescribeGroupResponse::externalIds))
            .setter(setter(Builder::externalIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExternalId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExternalId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeGroupResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(DescribeGroupResponse::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            DISPLAY_NAME_FIELD, EXTERNAL_IDS_FIELD, DESCRIPTION_FIELD, IDENTITY_STORE_ID_FIELD));

    private final String groupId;

    private final String displayName;

    private final List<ExternalId> externalIds;

    private final String description;

    private final String identityStoreId;

    private DescribeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.displayName = builder.displayName;
        this.externalIds = builder.externalIds;
        this.description = builder.description;
        this.identityStoreId = builder.identityStoreId;
    }

    /**
     * <p>
     * The identifier for a group in the identity store.
     * </p>
     * 
     * @return The identifier for a group in the identity store.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The group’s display name value. The length limit is 1,024 characters. This value can consist of letters, accented
     * characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking space in this
     * attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This value is specified at the time that the
     * group is created and stored as an attribute of the group object in the identity store.
     * </p>
     * 
     * @return The group’s display name value. The length limit is 1,024 characters. This value can consist of letters,
     *         accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and
     *         nonbreaking space in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This value is
     *         specified at the time that the group is created and stored as an attribute of the group object in the
     *         identity store.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalIds() {
        return externalIds != null && !(externalIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an external
     * identity provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalIds} method.
     * </p>
     * 
     * @return A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an
     *         external identity provider.
     */
    public final List<ExternalId> externalIds() {
        return externalIds;
    }

    /**
     * <p>
     * A string containing a description of the group.
     * </p>
     * 
     * @return A string containing a description of the group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalIds() ? externalIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupResponse)) {
            return false;
        }
        DescribeGroupResponse other = (DescribeGroupResponse) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(displayName(), other.displayName())
                && hasExternalIds() == other.hasExternalIds() && Objects.equals(externalIds(), other.externalIds())
                && Objects.equals(description(), other.description())
                && Objects.equals(identityStoreId(), other.identityStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGroupResponse").add("GroupId", groupId())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalIds", hasExternalIds() ? externalIds() : null)
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentityStoreId", identityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ExternalIds":
            return Optional.ofNullable(clazz.cast(externalIds()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupResponse, T> g) {
        return obj -> g.apply((DescribeGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGroupResponse> {
        /**
         * <p>
         * The identifier for a group in the identity store.
         * </p>
         * 
         * @param groupId
         *        The identifier for a group in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The group’s display name value. The length limit is 1,024 characters. This value can consist of letters,
         * accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking
         * space in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This value is specified at the
         * time that the group is created and stored as an attribute of the group object in the identity store.
         * </p>
         * 
         * @param displayName
         *        The group’s display name value. The length limit is 1,024 characters. This value can consist of
         *        letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space,
         *        and nonbreaking space in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This
         *        value is specified at the time that the group is created and stored as an attribute of the group
         *        object in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an
         * external identity provider.
         * </p>
         * 
         * @param externalIds
         *        A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an
         *        external identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIds(Collection<ExternalId> externalIds);

        /**
         * <p>
         * A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an
         * external identity provider.
         * </p>
         * 
         * @param externalIds
         *        A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an
         *        external identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIds(ExternalId... externalIds);

        /**
         * <p>
         * A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an
         * external identity provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.identitystore.model.ExternalId.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.identitystore.model.ExternalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.identitystore.model.ExternalId.Builder#build()} is called immediately
         * and its result is passed to {@link #externalIds(List<ExternalId>)}.
         * 
         * @param externalIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.identitystore.model.ExternalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalIds(java.util.Collection<ExternalId>)
         */
        Builder externalIds(Consumer<ExternalId.Builder>... externalIds);

        /**
         * <p>
         * A string containing a description of the group.
         * </p>
         * 
         * @param description
         *        A string containing a description of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);
    }

    static final class BuilderImpl extends IdentitystoreResponse.BuilderImpl implements Builder {
        private String groupId;

        private String displayName;

        private List<ExternalId> externalIds = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String identityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupResponse model) {
            super(model);
            groupId(model.groupId);
            displayName(model.displayName);
            externalIds(model.externalIds);
            description(model.description);
            identityStoreId(model.identityStoreId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<ExternalId.Builder> getExternalIds() {
            List<ExternalId.Builder> result = ExternalIdsCopier.copyToBuilder(this.externalIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalIds(Collection<ExternalId.BuilderImpl> externalIds) {
            this.externalIds = ExternalIdsCopier.copyFromBuilder(externalIds);
        }

        @Override
        public final Builder externalIds(Collection<ExternalId> externalIds) {
            this.externalIds = ExternalIdsCopier.copy(externalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(ExternalId... externalIds) {
            externalIds(Arrays.asList(externalIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(Consumer<ExternalId.Builder>... externalIds) {
            externalIds(Stream.of(externalIds).map(c -> ExternalId.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        @Override
        public DescribeGroupResponse build() {
            return new DescribeGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
