/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A query filter used by <code>ListUsers</code> and <code>ListGroup</code>. This filter object provides the attribute
 * name and attribute value to search users or groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> ATTRIBUTE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributePath").getter(getter(Filter::attributePath)).setter(setter(Builder::attributePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributePath").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeValue").getter(getter(Filter::attributeValue)).setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_PATH_FIELD,
            ATTRIBUTE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributePath;

    private final String attributeValue;

    private Filter(BuilderImpl builder) {
        this.attributePath = builder.attributePath;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The attribute path that is used to specify which attribute name to search. Length limit is 255 characters. For
     * example, <code>UserName</code> is a valid attribute path for the <code>ListUsers</code> API, and
     * <code>DisplayName</code> is a valid attribute path for the <code>ListGroups</code> API.
     * </p>
     * 
     * @return The attribute path that is used to specify which attribute name to search. Length limit is 255
     *         characters. For example, <code>UserName</code> is a valid attribute path for the <code>ListUsers</code>
     *         API, and <code>DisplayName</code> is a valid attribute path for the <code>ListGroups</code> API.
     */
    public final String attributePath() {
        return attributePath;
    }

    /**
     * <p>
     * Represents the data for an attribute. Each attribute value is described as a name-value pair.
     * </p>
     * 
     * @return Represents the data for an attribute. Each attribute value is described as a name-value pair.
     */
    public final String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributePath());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(attributePath(), other.attributePath()) && Objects.equals(attributeValue(), other.attributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("AttributePath", attributePath())
                .add("AttributeValue", attributeValue() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributePath":
            return Optional.ofNullable(clazz.cast(attributePath()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The attribute path that is used to specify which attribute name to search. Length limit is 255 characters.
         * For example, <code>UserName</code> is a valid attribute path for the <code>ListUsers</code> API, and
         * <code>DisplayName</code> is a valid attribute path for the <code>ListGroups</code> API.
         * </p>
         * 
         * @param attributePath
         *        The attribute path that is used to specify which attribute name to search. Length limit is 255
         *        characters. For example, <code>UserName</code> is a valid attribute path for the
         *        <code>ListUsers</code> API, and <code>DisplayName</code> is a valid attribute path for the
         *        <code>ListGroups</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePath(String attributePath);

        /**
         * <p>
         * Represents the data for an attribute. Each attribute value is described as a name-value pair.
         * </p>
         * 
         * @param attributeValue
         *        Represents the data for an attribute. Each attribute value is described as a name-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String attributePath;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            attributePath(model.attributePath);
            attributeValue(model.attributeValue);
        }

        public final String getAttributePath() {
            return attributePath;
        }

        public final void setAttributePath(String attributePath) {
            this.attributePath = attributePath;
        }

        @Override
        public final Builder attributePath(String attributePath) {
            this.attributePath = attributePath;
            return this;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
