/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserRequest extends IdentitystoreRequest implements
        ToCopyableBuilder<DescribeUserRequest.Builder, DescribeUserRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(DescribeUserRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DescribeUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            USER_ID_FIELD));

    private final String identityStoreId;

    private final String userId;

    private DescribeUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store, such as d-1234567890. In this example, d- is a fixed
     * prefix, and 1234567890 is a randomly generated string which contains number and lower case letters. This value is
     * generated at the time that a new identity store is created.
     * </p>
     * 
     * @return The globally unique identifier for the identity store, such as d-1234567890. In this example, d- is a
     *         fixed prefix, and 1234567890 is a randomly generated string which contains number and lower case letters.
     *         This value is generated at the time that a new identity store is created.
     */
    public String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The identifier for a user in the identity store.
     * </p>
     * 
     * @return The identifier for a user in the identity store.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserRequest)) {
            return false;
        }
        DescribeUserRequest other = (DescribeUserRequest) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserRequest").add("IdentityStoreId", identityStoreId()).add("UserId", userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserRequest, T> g) {
        return obj -> g.apply((DescribeUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserRequest> {
        /**
         * <p>
         * The globally unique identifier for the identity store, such as d-1234567890. In this example, d- is a fixed
         * prefix, and 1234567890 is a randomly generated string which contains number and lower case letters. This
         * value is generated at the time that a new identity store is created.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store, such as d-1234567890. In this example, d- is a
         *        fixed prefix, and 1234567890 is a randomly generated string which contains number and lower case
         *        letters. This value is generated at the time that a new identity store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The identifier for a user in the identity store.
         * </p>
         * 
         * @param userId
         *        The identifier for a user in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IdentitystoreRequest.BuilderImpl implements Builder {
        private String identityStoreId;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserRequest model) {
            super(model);
            identityStoreId(model.identityStoreId);
            userId(model.userId);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserRequest build() {
            return new DescribeUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
