/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRolePermissionsBoundaryRequest
extends IamRequest
implements ToCopyableBuilder<Builder, PutRolePermissionsBoundaryRequest> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(PutRolePermissionsBoundaryRequest.getter(PutRolePermissionsBoundaryRequest::roleName)).setter(PutRolePermissionsBoundaryRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionsBoundary").getter(PutRolePermissionsBoundaryRequest.getter(PutRolePermissionsBoundaryRequest::permissionsBoundary)).setter(PutRolePermissionsBoundaryRequest.setter(Builder::permissionsBoundary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD, PERMISSIONS_BOUNDARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRolePermissionsBoundaryRequest.memberNameToFieldInitializer();
    private final String roleName;
    private final String permissionsBoundary;

    private PutRolePermissionsBoundaryRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String permissionsBoundary() {
        return this.permissionsBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRolePermissionsBoundaryRequest)) {
            return false;
        }
        PutRolePermissionsBoundaryRequest other = (PutRolePermissionsBoundaryRequest)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary());
    }

    public final String toString() {
        return ToString.builder((String)"PutRolePermissionsBoundaryRequest").add("RoleName", (Object)this.roleName()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("PermissionsBoundary", PERMISSIONS_BOUNDARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRolePermissionsBoundaryRequest, T> g) {
        return obj -> g.apply((PutRolePermissionsBoundaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String roleName;
        private String permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRolePermissionsBoundaryRequest model) {
            super(model);
            this.roleName(model.roleName);
            this.permissionsBoundary(model.permissionsBoundary);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        public final void setPermissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
        }

        @Override
        public final Builder permissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRolePermissionsBoundaryRequest build() {
            return new PutRolePermissionsBoundaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRolePermissionsBoundaryRequest> {
        public Builder roleName(String var1);

        public Builder permissionsBoundary(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

