/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;

public class DescribeAffectedEntitiesIterable
implements SdkIterable<DescribeAffectedEntitiesResponse> {
    private final HealthClient client;
    private final DescribeAffectedEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAffectedEntitiesIterable(HealthClient client, DescribeAffectedEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAffectedEntitiesResponseFetcher();
    }

    public Iterator<DescribeAffectedEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AffectedEntity> entities() {
        Function<DescribeAffectedEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAffectedEntitiesResponseFetcher
    implements SyncPageFetcher<DescribeAffectedEntitiesResponse> {
        private DescribeAffectedEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAffectedEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAffectedEntitiesResponse nextPage(DescribeAffectedEntitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAffectedEntitiesIterable.this.client.describeAffectedEntities(DescribeAffectedEntitiesIterable.this.firstRequest);
            }
            return DescribeAffectedEntitiesIterable.this.client.describeAffectedEntities((DescribeAffectedEntitiesRequest)((Object)DescribeAffectedEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

