/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventAggregatesRequest extends HealthRequest implements
        ToCopyableBuilder<DescribeEventAggregatesRequest.Builder, DescribeEventAggregatesRequest> {
    private static final SdkField<EventFilter> FILTER_FIELD = SdkField.<EventFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(DescribeEventAggregatesRequest::filter)).setter(setter(Builder::filter))
            .constructor(EventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> AGGREGATE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregateField").getter(getter(DescribeEventAggregatesRequest::aggregateFieldAsString))
            .setter(setter(Builder::aggregateField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateField").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeEventAggregatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeEventAggregatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            AGGREGATE_FIELD_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final EventFilter filter;

    private final String aggregateField;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeEventAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.aggregateField = builder.aggregateField;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Values to narrow the results returned.
     * </p>
     * 
     * @return Values to narrow the results returned.
     */
    public final EventFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The only currently supported value is <code>eventTypeCategory</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregateField}
     * will return {@link EventAggregateField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #aggregateFieldAsString}.
     * </p>
     * 
     * @return The only currently supported value is <code>eventTypeCategory</code>.
     * @see EventAggregateField
     */
    public final EventAggregateField aggregateField() {
        return EventAggregateField.fromValue(aggregateField);
    }

    /**
     * <p>
     * The only currently supported value is <code>eventTypeCategory</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregateField}
     * will return {@link EventAggregateField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #aggregateFieldAsString}.
     * </p>
     * 
     * @return The only currently supported value is <code>eventTypeCategory</code>.
     * @see EventAggregateField
     */
    public final String aggregateFieldAsString() {
        return aggregateField;
    }

    /**
     * <p>
     * The maximum number of items to return in one batch, between 10 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return in one batch, between 10 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesRequest)) {
            return false;
        }
        DescribeEventAggregatesRequest other = (DescribeEventAggregatesRequest) obj;
        return Objects.equals(filter(), other.filter())
                && Objects.equals(aggregateFieldAsString(), other.aggregateFieldAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventAggregatesRequest").add("Filter", filter())
                .add("AggregateField", aggregateFieldAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "aggregateField":
            return Optional.ofNullable(clazz.cast(aggregateFieldAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventAggregatesRequest, T> g) {
        return obj -> g.apply((DescribeEventAggregatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventAggregatesRequest> {
        /**
         * <p>
         * Values to narrow the results returned.
         * </p>
         * 
         * @param filter
         *        Values to narrow the results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(EventFilter filter);

        /**
         * <p>
         * Values to narrow the results returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventFilter.Builder} avoiding the need to
         * create one manually via {@link EventFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(EventFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link EventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(EventFilter)
         */
        default Builder filter(Consumer<EventFilter.Builder> filter) {
            return filter(EventFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The only currently supported value is <code>eventTypeCategory</code>.
         * </p>
         * 
         * @param aggregateField
         *        The only currently supported value is <code>eventTypeCategory</code>.
         * @see EventAggregateField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventAggregateField
         */
        Builder aggregateField(String aggregateField);

        /**
         * <p>
         * The only currently supported value is <code>eventTypeCategory</code>.
         * </p>
         * 
         * @param aggregateField
         *        The only currently supported value is <code>eventTypeCategory</code>.
         * @see EventAggregateField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventAggregateField
         */
        Builder aggregateField(EventAggregateField aggregateField);

        /**
         * <p>
         * The maximum number of items to return in one batch, between 10 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in one batch, between 10 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthRequest.BuilderImpl implements Builder {
        private EventFilter filter;

        private String aggregateField;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesRequest model) {
            super(model);
            filter(model.filter);
            aggregateField(model.aggregateField);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final EventFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(EventFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(EventFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getAggregateField() {
            return aggregateField;
        }

        public final void setAggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
        }

        @Override
        public final Builder aggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
            return this;
        }

        @Override
        public final Builder aggregateField(EventAggregateField aggregateField) {
            this.aggregateField(aggregateField == null ? null : aggregateField.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventAggregatesRequest build() {
            return new DescribeEventAggregatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
