/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values to use to filter results from the <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html"
 * >DescribeAffectedEntities</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityFilter implements SdkPojo, Serializable, ToCopyableBuilder<EntityFilter.Builder, EntityFilter> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventArns")
            .getter(getter(EntityFilter::eventArns))
            .setter(setter(Builder::eventArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityArns")
            .getter(getter(EntityFilter::entityArns))
            .setter(setter(Builder::entityArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityValues")
            .getter(getter(EntityFilter::entityValues))
            .setter(setter(Builder::entityValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> LAST_UPDATED_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .memberName("lastUpdatedTimes")
            .getter(getter(EntityFilter::lastUpdatedTimes))
            .setter(setter(Builder::lastUpdatedTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> TAGS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(EntityFilter::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> STATUS_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusCodes")
            .getter(getter(EntityFilter::statusCodesAsStrings))
            .setter(setter(Builder::statusCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD,
            ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, LAST_UPDATED_TIMES_FIELD, TAGS_FIELD, STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventArns;

    private final List<String> entityArns;

    private final List<String> entityValues;

    private final List<DateTimeRange> lastUpdatedTimes;

    private final List<Map<String, String>> tags;

    private final List<String> statusCodes;

    private EntityFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.tags = builder.tags;
        this.statusCodes = builder.statusCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventArns() {
        return eventArns != null && !(eventArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event ARNs (unique identifiers). For example:
     * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventArns} method.
     * </p>
     * 
     * @return A list of event ARNs (unique identifiers). For example:
     *         <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     */
    public final List<String> eventArns() {
        return eventArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntityArns() {
        return entityArns != null && !(entityArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity ARNs (unique identifiers).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityArns} method.
     * </p>
     * 
     * @return A list of entity ARNs (unique identifiers).
     */
    public final List<String> entityArns() {
        return entityArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityValues() {
        return entityValues != null && !(entityValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs for affected entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityValues} method.
     * </p>
     * 
     * @return A list of IDs for affected entities.
     */
    public final List<String> entityValues() {
        return entityValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastUpdatedTimes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastUpdatedTimes() {
        return lastUpdatedTimes != null && !(lastUpdatedTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the most recent dates and times that the entity was updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastUpdatedTimes} method.
     * </p>
     * 
     * @return A list of the most recent dates and times that the entity was updated.
     */
    public final List<DateTimeRange> lastUpdatedTimes() {
        return lastUpdatedTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of entity tags attached to the affected entity.
     * </p>
     * <note>
     * <p>
     * Currently, the <code>tags</code> property isn't supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of entity tags attached to the affected entity.</p> <note>
     *         <p>
     *         Currently, the <code>tags</code> property isn't supported.
     *         </p>
     */
    public final List<Map<String, String>> tags() {
        return tags;
    }

    /**
     * <p>
     * A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusCodes} method.
     * </p>
     * 
     * @return A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
     */
    public final List<EntityStatusCode> statusCodes() {
        return _entityStatusCodeListCopier.copyStringToEnum(statusCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusCodes() {
        return statusCodes != null && !(statusCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusCodes} method.
     * </p>
     * 
     * @return A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
     */
    public final List<String> statusCodesAsStrings() {
        return statusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventArns() ? eventArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityArns() ? entityArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityValues() ? entityValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastUpdatedTimes() ? lastUpdatedTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusCodes() ? statusCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityFilter)) {
            return false;
        }
        EntityFilter other = (EntityFilter) obj;
        return hasEventArns() == other.hasEventArns() && Objects.equals(eventArns(), other.eventArns())
                && hasEntityArns() == other.hasEntityArns() && Objects.equals(entityArns(), other.entityArns())
                && hasEntityValues() == other.hasEntityValues() && Objects.equals(entityValues(), other.entityValues())
                && hasLastUpdatedTimes() == other.hasLastUpdatedTimes()
                && Objects.equals(lastUpdatedTimes(), other.lastUpdatedTimes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasStatusCodes() == other.hasStatusCodes()
                && Objects.equals(statusCodesAsStrings(), other.statusCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityFilter").add("EventArns", hasEventArns() ? eventArns() : null)
                .add("EntityArns", hasEntityArns() ? entityArns() : null)
                .add("EntityValues", hasEntityValues() ? entityValues() : null)
                .add("LastUpdatedTimes", hasLastUpdatedTimes() ? lastUpdatedTimes() : null)
                .add("Tags", hasTags() ? tags() : null).add("StatusCodes", hasStatusCodes() ? statusCodesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventArns":
            return Optional.ofNullable(clazz.cast(eventArns()));
        case "entityArns":
            return Optional.ofNullable(clazz.cast(entityArns()));
        case "entityValues":
            return Optional.ofNullable(clazz.cast(entityValues()));
        case "lastUpdatedTimes":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimes()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "statusCodes":
            return Optional.ofNullable(clazz.cast(statusCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityFilter, T> g) {
        return obj -> g.apply((EntityFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityFilter> {
        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArns
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArns(Collection<String> eventArns);

        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArns
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArns(String... eventArns);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(Collection<String> entityArns);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(String... entityArns);

        /**
         * <p>
         * A list of IDs for affected entities.
         * </p>
         * 
         * @param entityValues
         *        A list of IDs for affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(Collection<String> entityValues);

        /**
         * <p>
         * A list of IDs for affected entities.
         * </p>
         * 
         * @param entityValues
         *        A list of IDs for affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(String... entityValues);

        /**
         * <p>
         * A list of the most recent dates and times that the entity was updated.
         * </p>
         * 
         * @param lastUpdatedTimes
         *        A list of the most recent dates and times that the entity was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes);

        /**
         * <p>
         * A list of the most recent dates and times that the entity was updated.
         * </p>
         * 
         * @param lastUpdatedTimes
         *        A list of the most recent dates and times that the entity was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimes(DateTimeRange... lastUpdatedTimes);

        /**
         * <p>
         * A list of the most recent dates and times that the entity was updated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateTimeRange>.Builder} avoiding the need
         * to create one manually via {@link List<DateTimeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateTimeRange>.Builder#build()} is called immediately and
         * its result is passed to {@link #lastUpdatedTimes(List<DateTimeRange>)}.
         * 
         * @param lastUpdatedTimes
         *        a consumer that will call methods on {@link List<DateTimeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdatedTimes(List<DateTimeRange>)
         */
        Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder>... lastUpdatedTimes);

        /**
         * <p>
         * A map of entity tags attached to the affected entity.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>tags</code> property isn't supported.
         * </p>
         * </note>
         * 
         * @param tags
         *        A map of entity tags attached to the affected entity.</p> <note>
         *        <p>
         *        Currently, the <code>tags</code> property isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<? extends Map<String, String>> tags);

        /**
         * <p>
         * A map of entity tags attached to the affected entity.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>tags</code> property isn't supported.
         * </p>
         * </note>
         * 
         * @param tags
         *        A map of entity tags attached to the affected entity.</p> <note>
         *        <p>
         *        Currently, the <code>tags</code> property isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String>... tags);

        /**
         * <p>
         * A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodesWithStrings(Collection<String> statusCodes);

        /**
         * <p>
         * A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodesWithStrings(String... statusCodes);

        /**
         * <p>
         * A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(Collection<EntityStatusCode> statusCodes);

        /**
         * <p>
         * A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>).
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or <code>UNKNOWN</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(EntityStatusCode... statusCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> lastUpdatedTimes = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, String>> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> statusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityFilter model) {
            eventArns(model.eventArns);
            entityArns(model.entityArns);
            entityValues(model.entityValues);
            lastUpdatedTimes(model.lastUpdatedTimes);
            tags(model.tags);
            statusCodesWithStrings(model.statusCodes);
        }

        public final Collection<String> getEventArns() {
            if (eventArns instanceof SdkAutoConstructList) {
                return null;
            }
            return eventArns;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        @Override
        @Transient
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventArns(String... eventArns) {
            eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final Collection<String> getEntityArns() {
            if (entityArns instanceof SdkAutoConstructList) {
                return null;
            }
            return entityArns;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        @Override
        @Transient
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityArns(String... entityArns) {
            entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final Collection<String> getEntityValues() {
            if (entityValues instanceof SdkAutoConstructList) {
                return null;
            }
            return entityValues;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        @Override
        @Transient
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityValues(String... entityValues) {
            entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final List<DateTimeRange.Builder> getLastUpdatedTimes() {
            List<DateTimeRange.Builder> result = _dateTimeRangeListCopier.copyToBuilder(this.lastUpdatedTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange... lastUpdatedTimes) {
            lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder>... lastUpdatedTimes) {
            lastUpdatedTimes(Stream.of(lastUpdatedTimes).map(c -> DateTimeRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, String>> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags;
        }

        public final void setTags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Map<String, String>... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final Collection<String> getStatusCodes() {
            if (statusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return statusCodes;
        }

        public final void setStatusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
        }

        @Override
        @Transient
        public final Builder statusCodesWithStrings(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statusCodesWithStrings(String... statusCodes) {
            statusCodesWithStrings(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        @Transient
        public final Builder statusCodes(Collection<EntityStatusCode> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copyEnumToString(statusCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statusCodes(EntityStatusCode... statusCodes) {
            statusCodes(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        public EntityFilter build() {
            return new EntityFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
