/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAffectedAccountsForOrganizationResponse extends HealthResponse
        implements
        ToCopyableBuilder<DescribeAffectedAccountsForOrganizationResponse.Builder, DescribeAffectedAccountsForOrganizationResponse> {
    private static final SdkField<List<String>> AFFECTED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("affectedAccounts")
            .getter(getter(DescribeAffectedAccountsForOrganizationResponse::affectedAccounts))
            .setter(setter(Builder::affectedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_SCOPE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventScopeCode").getter(getter(DescribeAffectedAccountsForOrganizationResponse::eventScopeCodeAsString))
            .setter(setter(Builder::eventScopeCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventScopeCode").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAffectedAccountsForOrganizationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_ACCOUNTS_FIELD,
            EVENT_SCOPE_CODE_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> affectedAccounts;

    private final String eventScopeCode;

    private final String nextToken;

    private DescribeAffectedAccountsForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.affectedAccounts = builder.affectedAccounts;
        this.eventScopeCode = builder.eventScopeCode;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AffectedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAffectedAccounts() {
        return affectedAccounts != null && !(affectedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements of the affected accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAffectedAccounts} method.
     * </p>
     * 
     * @return A JSON set of elements of the affected accounts.
     */
    public final List<String> affectedAccounts() {
        return affectedAccounts;
    }

    /**
     * <p>
     * This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific
     * event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code> value is
     * always empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the <code>affectedAccounts</code>
     * value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a
     * service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service,
     * those account IDs appear in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you specified
     * in the request is invalid or doesn't exist.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventScopeCode}
     * will return {@link EventScopeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventScopeCodeAsString}.
     * </p>
     * 
     * @return This parameter specifies if the Health event is a public Amazon Web Services service event or an
     *         account-specific event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code>
     *         value is always empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the
     *         <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your organization.
     *         For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web
     *         Services accounts that use that service, those account IDs appear in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you
     *         specified in the request is invalid or doesn't exist.
     *         </p>
     *         </li>
     * @see EventScopeCode
     */
    public final EventScopeCode eventScopeCode() {
        return EventScopeCode.fromValue(eventScopeCode);
    }

    /**
     * <p>
     * This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific
     * event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code> value is
     * always empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the <code>affectedAccounts</code>
     * value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a
     * service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service,
     * those account IDs appear in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you specified
     * in the request is invalid or doesn't exist.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventScopeCode}
     * will return {@link EventScopeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventScopeCodeAsString}.
     * </p>
     * 
     * @return This parameter specifies if the Health event is a public Amazon Web Services service event or an
     *         account-specific event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code>
     *         value is always empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the
     *         <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your organization.
     *         For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web
     *         Services accounts that use that service, those account IDs appear in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you
     *         specified in the request is invalid or doesn't exist.
     *         </p>
     *         </li>
     * @see EventScopeCode
     */
    public final String eventScopeCodeAsString() {
        return eventScopeCode;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAffectedAccounts() ? affectedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventScopeCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedAccountsForOrganizationResponse)) {
            return false;
        }
        DescribeAffectedAccountsForOrganizationResponse other = (DescribeAffectedAccountsForOrganizationResponse) obj;
        return hasAffectedAccounts() == other.hasAffectedAccounts()
                && Objects.equals(affectedAccounts(), other.affectedAccounts())
                && Objects.equals(eventScopeCodeAsString(), other.eventScopeCodeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAffectedAccountsForOrganizationResponse")
                .add("AffectedAccounts", hasAffectedAccounts() ? affectedAccounts() : null)
                .add("EventScopeCode", eventScopeCodeAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "affectedAccounts":
            return Optional.ofNullable(clazz.cast(affectedAccounts()));
        case "eventScopeCode":
            return Optional.ofNullable(clazz.cast(eventScopeCodeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedAccountsForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeAffectedAccountsForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAffectedAccountsForOrganizationResponse> {
        /**
         * <p>
         * A JSON set of elements of the affected accounts.
         * </p>
         * 
         * @param affectedAccounts
         *        A JSON set of elements of the affected accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedAccounts(Collection<String> affectedAccounts);

        /**
         * <p>
         * A JSON set of elements of the affected accounts.
         * </p>
         * 
         * @param affectedAccounts
         *        A JSON set of elements of the affected accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedAccounts(String... affectedAccounts);

        /**
         * <p>
         * This parameter specifies if the Health event is a public Amazon Web Services service event or an
         * account-specific event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code> value
         * is always empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the
         * <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your organization. For
         * example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services
         * accounts that use that service, those account IDs appear in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you
         * specified in the request is invalid or doesn't exist.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventScopeCode
         *        This parameter specifies if the Health event is a public Amazon Web Services service event or an
         *        account-specific event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
         *        <code>affectedAccounts</code> value is always empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the
         *        <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your
         *        organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
         *        have Amazon Web Services accounts that use that service, those account IDs appear in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you
         *        specified in the request is invalid or doesn't exist.
         *        </p>
         *        </li>
         * @see EventScopeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventScopeCode
         */
        Builder eventScopeCode(String eventScopeCode);

        /**
         * <p>
         * This parameter specifies if the Health event is a public Amazon Web Services service event or an
         * account-specific event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code> value
         * is always empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the
         * <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your organization. For
         * example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services
         * accounts that use that service, those account IDs appear in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you
         * specified in the request is invalid or doesn't exist.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventScopeCode
         *        This parameter specifies if the Health event is a public Amazon Web Services service event or an
         *        account-specific event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
         *        <code>affectedAccounts</code> value is always empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the
         *        <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your
         *        organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
         *        have Amazon Web Services accounts that use that service, those account IDs appear in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you
         *        specified in the request is invalid or doesn't exist.
         *        </p>
         *        </li>
         * @see EventScopeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventScopeCode
         */
        Builder eventScopeCode(EventScopeCode eventScopeCode);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<String> affectedAccounts = DefaultSdkAutoConstructList.getInstance();

        private String eventScopeCode;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedAccountsForOrganizationResponse model) {
            super(model);
            affectedAccounts(model.affectedAccounts);
            eventScopeCode(model.eventScopeCode);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAffectedAccounts() {
            if (affectedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return affectedAccounts;
        }

        public final void setAffectedAccounts(Collection<String> affectedAccounts) {
            this.affectedAccounts = _affectedAccountsListCopier.copy(affectedAccounts);
        }

        @Override
        @Transient
        public final Builder affectedAccounts(Collection<String> affectedAccounts) {
            this.affectedAccounts = _affectedAccountsListCopier.copy(affectedAccounts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder affectedAccounts(String... affectedAccounts) {
            affectedAccounts(Arrays.asList(affectedAccounts));
            return this;
        }

        public final String getEventScopeCode() {
            return eventScopeCode;
        }

        public final void setEventScopeCode(String eventScopeCode) {
            this.eventScopeCode = eventScopeCode;
        }

        @Override
        @Transient
        public final Builder eventScopeCode(String eventScopeCode) {
            this.eventScopeCode = eventScopeCode;
            return this;
        }

        @Override
        @Transient
        public final Builder eventScopeCode(EventScopeCode eventScopeCode) {
            this.eventScopeCode(eventScopeCode == null ? null : eventScopeCode.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAffectedAccountsForOrganizationResponse build() {
            return new DescribeAffectedAccountsForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
