/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsFailedSetCopier;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsSuccessfulSetCopier;
import software.amazon.awssdk.services.health.model.EventDetails;
import software.amazon.awssdk.services.health.model.EventDetailsErrorItem;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventDetailsResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEventDetailsResponse> {
    private static final SdkField<List<EventDetails>> SUCCESSFUL_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulSet").getter(DescribeEventDetailsResponse.getter(DescribeEventDetailsResponse::successfulSet)).setter(DescribeEventDetailsResponse.setter(Builder::successfulSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EventDetailsErrorItem>> FAILED_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedSet").getter(DescribeEventDetailsResponse.getter(DescribeEventDetailsResponse::failedSet)).setter(DescribeEventDetailsResponse.setter(Builder::failedSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDetailsErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SET_FIELD, FAILED_SET_FIELD));
    private final List<EventDetails> successfulSet;
    private final List<EventDetailsErrorItem> failedSet;

    private DescribeEventDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSet = builder.successfulSet;
        this.failedSet = builder.failedSet;
    }

    public final boolean hasSuccessfulSet() {
        return this.successfulSet != null && !(this.successfulSet instanceof SdkAutoConstructList);
    }

    public final List<EventDetails> successfulSet() {
        return this.successfulSet;
    }

    public final boolean hasFailedSet() {
        return this.failedSet != null && !(this.failedSet instanceof SdkAutoConstructList);
    }

    public final List<EventDetailsErrorItem> failedSet() {
        return this.failedSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulSet() ? this.successfulSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedSet() ? this.failedSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsResponse)) {
            return false;
        }
        DescribeEventDetailsResponse other = (DescribeEventDetailsResponse)((Object)obj);
        return this.hasSuccessfulSet() == other.hasSuccessfulSet() && Objects.equals(this.successfulSet(), other.successfulSet()) && this.hasFailedSet() == other.hasFailedSet() && Objects.equals(this.failedSet(), other.failedSet());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventDetailsResponse").add("SuccessfulSet", this.hasSuccessfulSet() ? this.successfulSet() : null).add("FailedSet", this.hasFailedSet() ? this.failedSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulSet": {
                return Optional.ofNullable(clazz.cast(this.successfulSet()));
            }
            case "failedSet": {
                return Optional.ofNullable(clazz.cast(this.failedSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventDetailsResponse, T> g) {
        return obj -> g.apply((DescribeEventDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<EventDetails> successfulSet = DefaultSdkAutoConstructList.getInstance();
        private List<EventDetailsErrorItem> failedSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsResponse model) {
            super(model);
            this.successfulSet(model.successfulSet);
            this.failedSet(model.failedSet);
        }

        public final List<EventDetails.Builder> getSuccessfulSet() {
            List<EventDetails.Builder> result = DescribeEventDetailsSuccessfulSetCopier.copyToBuilder(this.successfulSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulSet(Collection<EventDetails.BuilderImpl> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copyFromBuilder(successfulSet);
        }

        @Override
        @Transient
        public final Builder successfulSet(Collection<EventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copy(successfulSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successfulSet(EventDetails ... successfulSet) {
            this.successfulSet(Arrays.asList(successfulSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successfulSet(Consumer<EventDetails.Builder> ... successfulSet) {
            this.successfulSet(Stream.of(successfulSet).map(c -> (EventDetails)((EventDetails.Builder)EventDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EventDetailsErrorItem.Builder> getFailedSet() {
            List<EventDetailsErrorItem.Builder> result = DescribeEventDetailsFailedSetCopier.copyToBuilder(this.failedSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedSet(Collection<EventDetailsErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copyFromBuilder(failedSet);
        }

        @Override
        @Transient
        public final Builder failedSet(Collection<EventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedSet(EventDetailsErrorItem ... failedSet) {
            this.failedSet(Arrays.asList(failedSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedSet(Consumer<EventDetailsErrorItem.Builder> ... failedSet) {
            this.failedSet(Stream.of(failedSet).map(c -> (EventDetailsErrorItem)((EventDetailsErrorItem.Builder)EventDetailsErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventDetailsResponse build() {
            return new DescribeEventDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventDetailsResponse> {
        public Builder successfulSet(Collection<EventDetails> var1);

        public Builder successfulSet(EventDetails ... var1);

        public Builder successfulSet(Consumer<EventDetails.Builder> ... var1);

        public Builder failedSet(Collection<EventDetailsErrorItem> var1);

        public Builder failedSet(EventDetailsErrorItem ... var1);

        public Builder failedSet(Consumer<EventDetailsErrorItem.Builder> ... var1);
    }
}

