/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error information returned when a <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html"
 * >DescribeAffectedEntitiesForOrganization</a> operation can't find or process a specific entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationAffectedEntitiesErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationAffectedEntitiesErrorItem.Builder, OrganizationAffectedEntitiesErrorItem> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(OrganizationAffectedEntitiesErrorItem::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventArn").getter(getter(OrganizationAffectedEntitiesErrorItem::eventArn))
            .setter(setter(Builder::eventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()).build();

    private static final SdkField<String> ERROR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorName").getter(getter(OrganizationAffectedEntitiesErrorItem::errorName))
            .setter(setter(Builder::errorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorName").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(OrganizationAffectedEntitiesErrorItem::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            EVENT_ARN_FIELD, ERROR_NAME_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String eventArn;

    private final String errorName;

    private final String errorMessage;

    private OrganizationAffectedEntitiesErrorItem(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.eventArn = builder.eventArn;
        this.errorName = builder.errorName;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The 12-digit AWS account numbers that contains the affected entities.
     * </p>
     * 
     * @return The 12-digit AWS account numbers that contains the affected entities.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The unique identifier for the event. The event ARN has the
     * <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
     * format.
     * </p>
     * <p>
     * For example, an event ARN might look like the following:
     * </p>
     * <p>
     * <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
     * </p>
     * 
     * @return The unique identifier for the event. The event ARN has the
     *         <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
     *         format.</p>
     *         <p>
     *         For example, an event ARN might look like the following:
     *         </p>
     *         <p>
     *         <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
     */
    public final String eventArn() {
        return eventArn;
    }

    /**
     * <p>
     * The name of the error.
     * </p>
     * 
     * @return The name of the error.
     */
    public final String errorName() {
        return errorName;
    }

    /**
     * <p>
     * The unique identifier for the event type. The format is <code>AWS_SERVICE_DESCRIPTION</code>. For example,
     * <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.
     * </p>
     * 
     * @return The unique identifier for the event type. The format is <code>AWS_SERVICE_DESCRIPTION</code>. For
     *         example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorName());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationAffectedEntitiesErrorItem)) {
            return false;
        }
        OrganizationAffectedEntitiesErrorItem other = (OrganizationAffectedEntitiesErrorItem) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(eventArn(), other.eventArn())
                && Objects.equals(errorName(), other.errorName()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationAffectedEntitiesErrorItem").add("AwsAccountId", awsAccountId())
                .add("EventArn", eventArn()).add("ErrorName", errorName()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "eventArn":
            return Optional.ofNullable(clazz.cast(eventArn()));
        case "errorName":
            return Optional.ofNullable(clazz.cast(errorName()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationAffectedEntitiesErrorItem, T> g) {
        return obj -> g.apply((OrganizationAffectedEntitiesErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationAffectedEntitiesErrorItem> {
        /**
         * <p>
         * The 12-digit AWS account numbers that contains the affected entities.
         * </p>
         * 
         * @param awsAccountId
         *        The 12-digit AWS account numbers that contains the affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The unique identifier for the event. The event ARN has the
         * <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
         * format.
         * </p>
         * <p>
         * For example, an event ARN might look like the following:
         * </p>
         * <p>
         * <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
         * </p>
         * 
         * @param eventArn
         *        The unique identifier for the event. The event ARN has the
         *        <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
         *        format.</p>
         *        <p>
         *        For example, an event ARN might look like the following:
         *        </p>
         *        <p>
         *        <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArn(String eventArn);

        /**
         * <p>
         * The name of the error.
         * </p>
         * 
         * @param errorName
         *        The name of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorName(String errorName);

        /**
         * <p>
         * The unique identifier for the event type. The format is <code>AWS_SERVICE_DESCRIPTION</code>. For example,
         * <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.
         * </p>
         * 
         * @param errorMessage
         *        The unique identifier for the event type. The format is <code>AWS_SERVICE_DESCRIPTION</code>. For
         *        example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String eventArn;

        private String errorName;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationAffectedEntitiesErrorItem model) {
            awsAccountId(model.awsAccountId);
            eventArn(model.eventArn);
            errorName(model.errorName);
            errorMessage(model.errorMessage);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getEventArn() {
            return eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        @Transient
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final String getErrorName() {
            return errorName;
        }

        public final void setErrorName(String errorName) {
            this.errorName = errorName;
        }

        @Override
        @Transient
        public final Builder errorName(String errorName) {
            this.errorName = errorName;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public OrganizationAffectedEntitiesErrorItem build() {
            return new OrganizationAffectedEntitiesErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
