/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventDetailsResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEventDetailsResponse.Builder, DescribeEventDetailsResponse> {
    private static final SdkField<List<EventDetails>> SUCCESSFUL_SET_FIELD = SdkField
            .<List<EventDetails>> builder(MarshallingType.LIST)
            .memberName("successfulSet")
            .getter(getter(DescribeEventDetailsResponse::successfulSet))
            .setter(setter(Builder::successfulSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EventDetailsErrorItem>> FAILED_SET_FIELD = SdkField
            .<List<EventDetailsErrorItem>> builder(MarshallingType.LIST)
            .memberName("failedSet")
            .getter(getter(DescribeEventDetailsResponse::failedSet))
            .setter(setter(Builder::failedSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventDetailsErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventDetailsErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SET_FIELD,
            FAILED_SET_FIELD));

    private final List<EventDetails> successfulSet;

    private final List<EventDetailsErrorItem> failedSet;

    private DescribeEventDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSet = builder.successfulSet;
        this.failedSet = builder.failedSet;
    }

    /**
     * Returns true if the SuccessfulSet property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSuccessfulSet() {
        return successfulSet != null && !(successfulSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the events that could be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the events that could be retrieved.
     */
    public List<EventDetails> successfulSet() {
        return successfulSet;
    }

    /**
     * Returns true if the FailedSet property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedSet() {
        return failedSet != null && !(failedSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error messages for any events that could not be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Error messages for any events that could not be retrieved.
     */
    public List<EventDetailsErrorItem> failedSet() {
        return failedSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulSet() ? successfulSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedSet() ? failedSet() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsResponse)) {
            return false;
        }
        DescribeEventDetailsResponse other = (DescribeEventDetailsResponse) obj;
        return hasSuccessfulSet() == other.hasSuccessfulSet() && Objects.equals(successfulSet(), other.successfulSet())
                && hasFailedSet() == other.hasFailedSet() && Objects.equals(failedSet(), other.failedSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventDetailsResponse").add("SuccessfulSet", hasSuccessfulSet() ? successfulSet() : null)
                .add("FailedSet", hasFailedSet() ? failedSet() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successfulSet":
            return Optional.ofNullable(clazz.cast(successfulSet()));
        case "failedSet":
            return Optional.ofNullable(clazz.cast(failedSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventDetailsResponse, T> g) {
        return obj -> g.apply((DescribeEventDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventDetailsResponse> {
        /**
         * <p>
         * Information about the events that could be retrieved.
         * </p>
         * 
         * @param successfulSet
         *        Information about the events that could be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulSet(Collection<EventDetails> successfulSet);

        /**
         * <p>
         * Information about the events that could be retrieved.
         * </p>
         * 
         * @param successfulSet
         *        Information about the events that could be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulSet(EventDetails... successfulSet);

        /**
         * <p>
         * Information about the events that could be retrieved.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventDetails>.Builder} avoiding the need to
         * create one manually via {@link List<EventDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #successfulSet(List<EventDetails>)}.
         * 
         * @param successfulSet
         *        a consumer that will call methods on {@link List<EventDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulSet(List<EventDetails>)
         */
        Builder successfulSet(Consumer<EventDetails.Builder>... successfulSet);

        /**
         * <p>
         * Error messages for any events that could not be retrieved.
         * </p>
         * 
         * @param failedSet
         *        Error messages for any events that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSet(Collection<EventDetailsErrorItem> failedSet);

        /**
         * <p>
         * Error messages for any events that could not be retrieved.
         * </p>
         * 
         * @param failedSet
         *        Error messages for any events that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSet(EventDetailsErrorItem... failedSet);

        /**
         * <p>
         * Error messages for any events that could not be retrieved.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventDetailsErrorItem>.Builder} avoiding
         * the need to create one manually via {@link List<EventDetailsErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventDetailsErrorItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedSet(List<EventDetailsErrorItem>)}.
         * 
         * @param failedSet
         *        a consumer that will call methods on {@link List<EventDetailsErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedSet(List<EventDetailsErrorItem>)
         */
        Builder failedSet(Consumer<EventDetailsErrorItem.Builder>... failedSet);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<EventDetails> successfulSet = DefaultSdkAutoConstructList.getInstance();

        private List<EventDetailsErrorItem> failedSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsResponse model) {
            super(model);
            successfulSet(model.successfulSet);
            failedSet(model.failedSet);
        }

        public final Collection<EventDetails.Builder> getSuccessfulSet() {
            if (successfulSet instanceof SdkAutoConstructList) {
                return null;
            }
            return successfulSet != null ? successfulSet.stream().map(EventDetails::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder successfulSet(Collection<EventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copy(successfulSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(EventDetails... successfulSet) {
            successfulSet(Arrays.asList(successfulSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(Consumer<EventDetails.Builder>... successfulSet) {
            successfulSet(Stream.of(successfulSet).map(c -> EventDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulSet(Collection<EventDetails.BuilderImpl> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copyFromBuilder(successfulSet);
        }

        public final Collection<EventDetailsErrorItem.Builder> getFailedSet() {
            if (failedSet instanceof SdkAutoConstructList) {
                return null;
            }
            return failedSet != null ? failedSet.stream().map(EventDetailsErrorItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder failedSet(Collection<EventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(EventDetailsErrorItem... failedSet) {
            failedSet(Arrays.asList(failedSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(Consumer<EventDetailsErrorItem.Builder>... failedSet) {
            failedSet(Stream.of(failedSet).map(c -> EventDetailsErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedSet(Collection<EventDetailsErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copyFromBuilder(failedSet);
        }

        @Override
        public DescribeEventDetailsResponse build() {
            return new DescribeEventDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
