/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityAggregate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityAggregate> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EntityAggregate.getter(EntityAggregate::eventArn)).setter(EntityAggregate.setter(Builder::eventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EntityAggregate.getter(EntityAggregate::count)).setter(EntityAggregate.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD, COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventArn;
    private final Integer count;

    private EntityAggregate(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.count = builder.count;
    }

    public String eventArn() {
        return this.eventArn;
    }

    public Integer count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityAggregate)) {
            return false;
        }
        EntityAggregate other = (EntityAggregate)obj;
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.count(), other.count());
    }

    public String toString() {
        return ToString.builder((String)"EntityAggregate").add("EventArn", (Object)this.eventArn()).add("Count", (Object)this.count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArn": {
                return Optional.ofNullable(clazz.cast(this.eventArn()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityAggregate, T> g) {
        return obj -> g.apply((EntityAggregate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventArn;
        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityAggregate model) {
            this.eventArn(model.eventArn);
            this.count(model.count);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public EntityAggregate build() {
            return new EntityAggregate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityAggregate> {
        public Builder eventArn(String var1);

        public Builder count(Integer var1);
    }
}

