/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHealthServiceStatusForOrganizationResponse extends HealthResponse
        implements
        ToCopyableBuilder<DescribeHealthServiceStatusForOrganizationResponse.Builder, DescribeHealthServiceStatusForOrganizationResponse> {
    private static final SdkField<String> HEALTH_SERVICE_ACCESS_STATUS_FOR_ORGANIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHealthServiceStatusForOrganizationResponse::healthServiceAccessStatusForOrganization))
            .setter(setter(Builder::healthServiceAccessStatusForOrganization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("healthServiceAccessStatusForOrganization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HEALTH_SERVICE_ACCESS_STATUS_FOR_ORGANIZATION_FIELD));

    private final String healthServiceAccessStatusForOrganization;

    private DescribeHealthServiceStatusForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.healthServiceAccessStatusForOrganization = builder.healthServiceAccessStatusForOrganization;
    }

    /**
     * <p>
     * Information about the status of enabling or disabling AWS Health Organizational View in your organization.
     * </p>
     * <p>
     * Valid values are <code>ENABLED | DISABLED | PENDING</code>.
     * </p>
     * 
     * @return Information about the status of enabling or disabling AWS Health Organizational View in your
     *         organization.</p>
     *         <p>
     *         Valid values are <code>ENABLED | DISABLED | PENDING</code>.
     */
    public String healthServiceAccessStatusForOrganization() {
        return healthServiceAccessStatusForOrganization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(healthServiceAccessStatusForOrganization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHealthServiceStatusForOrganizationResponse)) {
            return false;
        }
        DescribeHealthServiceStatusForOrganizationResponse other = (DescribeHealthServiceStatusForOrganizationResponse) obj;
        return Objects.equals(healthServiceAccessStatusForOrganization(), other.healthServiceAccessStatusForOrganization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeHealthServiceStatusForOrganizationResponse")
                .add("HealthServiceAccessStatusForOrganization", healthServiceAccessStatusForOrganization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthServiceAccessStatusForOrganization":
            return Optional.ofNullable(clazz.cast(healthServiceAccessStatusForOrganization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHealthServiceStatusForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeHealthServiceStatusForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHealthServiceStatusForOrganizationResponse> {
        /**
         * <p>
         * Information about the status of enabling or disabling AWS Health Organizational View in your organization.
         * </p>
         * <p>
         * Valid values are <code>ENABLED | DISABLED | PENDING</code>.
         * </p>
         * 
         * @param healthServiceAccessStatusForOrganization
         *        Information about the status of enabling or disabling AWS Health Organizational View in your
         *        organization.</p>
         *        <p>
         *        Valid values are <code>ENABLED | DISABLED | PENDING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthServiceAccessStatusForOrganization(String healthServiceAccessStatusForOrganization);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private String healthServiceAccessStatusForOrganization;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHealthServiceStatusForOrganizationResponse model) {
            super(model);
            healthServiceAccessStatusForOrganization(model.healthServiceAccessStatusForOrganization);
        }

        public final String getHealthServiceAccessStatusForOrganization() {
            return healthServiceAccessStatusForOrganization;
        }

        @Override
        public final Builder healthServiceAccessStatusForOrganization(String healthServiceAccessStatusForOrganization) {
            this.healthServiceAccessStatusForOrganization = healthServiceAccessStatusForOrganization;
            return this;
        }

        public final void setHealthServiceAccessStatusForOrganization(String healthServiceAccessStatusForOrganization) {
            this.healthServiceAccessStatusForOrganization = healthServiceAccessStatusForOrganization;
        }

        @Override
        public DescribeHealthServiceStatusForOrganizationResponse build() {
            return new DescribeHealthServiceStatusForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
