/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model._availabilityZonesCopier;
import software.amazon.awssdk.services.health.model._dateTimeRangeListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.services.health.model._eventStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._eventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model._eventTypeListCopier;
import software.amazon.awssdk.services.health.model._regionListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.services.health.model._tagFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventFilter> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::eventArns)).setter(EventFilter.setter(Builder::eventArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::eventTypeCodes)).setter(EventFilter.setter(Builder::eventTypeCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::services)).setter(EventFilter.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::regions)).setter(EventFilter.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::availabilityZones)).setter(EventFilter.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateTimeRange>> START_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::startTimes)).setter(EventFilter.setter(Builder::startTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateTimeRange>> END_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::endTimes)).setter(EventFilter.setter(Builder::endTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateTimeRange>> LAST_UPDATED_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::lastUpdatedTimes)).setter(EventFilter.setter(Builder::lastUpdatedTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::entityArns)).setter(EventFilter.setter(Builder::entityArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::entityValues)).setter(EventFilter.setter(Builder::entityValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::eventTypeCategoriesAsStrings)).setter(EventFilter.setter(Builder::eventTypeCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, String>>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::tags)).setter(EventFilter.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_STATUS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventFilter.getter(EventFilter::eventStatusCodesAsStrings)).setter(EventFilter.setter(Builder::eventStatusCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatusCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD, EVENT_TYPE_CODES_FIELD, SERVICES_FIELD, REGIONS_FIELD, AVAILABILITY_ZONES_FIELD, START_TIMES_FIELD, END_TIMES_FIELD, LAST_UPDATED_TIMES_FIELD, ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, EVENT_TYPE_CATEGORIES_FIELD, TAGS_FIELD, EVENT_STATUS_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> eventArns;
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> regions;
    private final List<String> availabilityZones;
    private final List<DateTimeRange> startTimes;
    private final List<DateTimeRange> endTimes;
    private final List<DateTimeRange> lastUpdatedTimes;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<String> eventTypeCategories;
    private final List<Map<String, String>> tags;
    private final List<String> eventStatusCodes;

    private EventFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.regions = builder.regions;
        this.availabilityZones = builder.availabilityZones;
        this.startTimes = builder.startTimes;
        this.endTimes = builder.endTimes;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.tags = builder.tags;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public List<String> services() {
        return this.services;
    }

    public List<String> regions() {
        return this.regions;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<DateTimeRange> startTimes() {
        return this.startTimes;
    }

    public List<DateTimeRange> endTimes() {
        return this.endTimes;
    }

    public List<DateTimeRange> lastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public List<String> entityArns() {
        return this.entityArns;
    }

    public List<String> entityValues() {
        return this.entityValues;
    }

    public List<EventTypeCategory> eventTypeCategories() {
        return _eventTypeCategoryListCopier.copyStringToEnum(this.eventTypeCategories);
    }

    public List<String> eventTypeCategoriesAsStrings() {
        return this.eventTypeCategories;
    }

    public List<Map<String, String>> tags() {
        return this.tags;
    }

    public List<EventStatusCode> eventStatusCodes() {
        return _eventStatusCodeListCopier.copyStringToEnum(this.eventStatusCodes);
    }

    public List<String> eventStatusCodesAsStrings() {
        return this.eventStatusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.regions());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCategoriesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusCodesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)obj;
        return Objects.equals(this.eventArns(), other.eventArns()) && Objects.equals(this.eventTypeCodes(), other.eventTypeCodes()) && Objects.equals(this.services(), other.services()) && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.startTimes(), other.startTimes()) && Objects.equals(this.endTimes(), other.endTimes()) && Objects.equals(this.lastUpdatedTimes(), other.lastUpdatedTimes()) && Objects.equals(this.entityArns(), other.entityArns()) && Objects.equals(this.entityValues(), other.entityValues()) && Objects.equals(this.eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.eventStatusCodesAsStrings(), other.eventStatusCodesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"EventFilter").add("EventArns", this.eventArns()).add("EventTypeCodes", this.eventTypeCodes()).add("Services", this.services()).add("Regions", this.regions()).add("AvailabilityZones", this.availabilityZones()).add("StartTimes", this.startTimes()).add("EndTimes", this.endTimes()).add("LastUpdatedTimes", this.lastUpdatedTimes()).add("EntityArns", this.entityArns()).add("EntityValues", this.entityValues()).add("EventTypeCategories", this.eventTypeCategoriesAsStrings()).add("Tags", this.tags()).add("EventStatusCodes", this.eventStatusCodesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.ofNullable(clazz.cast(this.eventArns()));
            }
            case "eventTypeCodes": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCodes()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "availabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "startTimes": {
                return Optional.ofNullable(clazz.cast(this.startTimes()));
            }
            case "endTimes": {
                return Optional.ofNullable(clazz.cast(this.endTimes()));
            }
            case "lastUpdatedTimes": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimes()));
            }
            case "entityArns": {
                return Optional.ofNullable(clazz.cast(this.entityArns()));
            }
            case "entityValues": {
                return Optional.ofNullable(clazz.cast(this.entityValues()));
            }
            case "eventTypeCategories": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCategoriesAsStrings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "eventStatusCodes": {
                return Optional.ofNullable(clazz.cast(this.eventStatusCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> services = DefaultSdkAutoConstructList.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<DateTimeRange> startTimes = DefaultSdkAutoConstructList.getInstance();
        private List<DateTimeRange> endTimes = DefaultSdkAutoConstructList.getInstance();
        private List<DateTimeRange> lastUpdatedTimes = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, String>> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventStatusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            this.eventArns(model.eventArns);
            this.eventTypeCodes(model.eventTypeCodes);
            this.services(model.services);
            this.regions(model.regions);
            this.availabilityZones(model.availabilityZones);
            this.startTimes(model.startTimes);
            this.endTimes(model.endTimes);
            this.lastUpdatedTimes(model.lastUpdatedTimes);
            this.entityArns(model.entityArns);
            this.entityValues(model.entityValues);
            this.eventTypeCategoriesWithStrings(model.eventTypeCategories);
            this.tags(model.tags);
            this.eventStatusCodesWithStrings(model.eventStatusCodes);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEventTypeCodes() {
            return this.eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<DateTimeRange.Builder> getStartTimes() {
            return this.startTimes != null ? (Collection)this.startTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startTimes(Collection<DateTimeRange> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copy(startTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(DateTimeRange ... startTimes) {
            this.startTimes(Arrays.asList(startTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(Consumer<DateTimeRange.Builder> ... startTimes) {
            this.startTimes(Stream.of(startTimes).map(c -> (DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStartTimes(Collection<DateTimeRange.BuilderImpl> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copyFromBuilder(startTimes);
        }

        public final Collection<DateTimeRange.Builder> getEndTimes() {
            return this.endTimes != null ? (Collection)this.endTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endTimes(Collection<DateTimeRange> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(DateTimeRange ... endTimes) {
            this.endTimes(Arrays.asList(endTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(Consumer<DateTimeRange.Builder> ... endTimes) {
            this.endTimes(Stream.of(endTimes).map(c -> (DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndTimes(Collection<DateTimeRange.BuilderImpl> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copyFromBuilder(endTimes);
        }

        public final Collection<DateTimeRange.Builder> getLastUpdatedTimes() {
            return this.lastUpdatedTimes != null ? (Collection)this.lastUpdatedTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder> ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Stream.of(lastUpdatedTimes).map(c -> (DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        public final Collection<String> getEntityArns() {
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<String> getEventTypeCategoriesAsStrings() {
            return this.eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String ... eventTypeCategories) {
            this.eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final void setEventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public final Collection<? extends Map<String, String>> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String> ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getEventStatusCodesAsStrings() {
            return this.eventStatusCodes;
        }

        @Override
        public final Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodesWithStrings(String ... eventStatusCodes) {
            this.eventStatusCodesWithStrings(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        public final Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copyEnumToString(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(EventStatusCode ... eventStatusCodes) {
            this.eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        public final void setEventStatusCodesWithStrings(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        public EventFilter build() {
            return new EventFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventFilter> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder startTimes(Collection<DateTimeRange> var1);

        public Builder startTimes(DateTimeRange ... var1);

        public Builder startTimes(Consumer<DateTimeRange.Builder> ... var1);

        public Builder endTimes(Collection<DateTimeRange> var1);

        public Builder endTimes(DateTimeRange ... var1);

        public Builder endTimes(Consumer<DateTimeRange.Builder> ... var1);

        public Builder lastUpdatedTimes(Collection<DateTimeRange> var1);

        public Builder lastUpdatedTimes(DateTimeRange ... var1);

        public Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder> ... var1);

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder eventTypeCategoriesWithStrings(Collection<String> var1);

        public Builder eventTypeCategoriesWithStrings(String ... var1);

        public Builder eventTypeCategories(Collection<EventTypeCategory> var1);

        public Builder eventTypeCategories(EventTypeCategory ... var1);

        public Builder tags(Collection<? extends Map<String, String>> var1);

        public Builder tags(Map<String, String> ... var1);

        public Builder eventStatusCodesWithStrings(Collection<String> var1);

        public Builder eventStatusCodesWithStrings(String ... var1);

        public Builder eventStatusCodes(Collection<EventStatusCode> var1);

        public Builder eventStatusCodes(EventStatusCode ... var1);
    }
}

