/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAgentConfigurationResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetAgentConfigurationResponse> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(GetAgentConfigurationResponse.getter(GetAgentConfigurationResponse::agentId)).setter(GetAgentConfigurationResponse.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> TASKING_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskingDocument").getter(GetAgentConfigurationResponse.getter(GetAgentConfigurationResponse::taskingDocument)).setter(GetAgentConfigurationResponse.setter(Builder::taskingDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskingDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, TASKING_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAgentConfigurationResponse.memberNameToFieldInitializer();
    private final String agentId;
    private final String taskingDocument;

    private GetAgentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.taskingDocument = builder.taskingDocument;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String taskingDocument() {
        return this.taskingDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskingDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentConfigurationResponse)) {
            return false;
        }
        GetAgentConfigurationResponse other = (GetAgentConfigurationResponse)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.taskingDocument(), other.taskingDocument());
    }

    public final String toString() {
        return ToString.builder((String)"GetAgentConfigurationResponse").add("AgentId", (Object)this.agentId()).add("TaskingDocument", (Object)this.taskingDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "taskingDocument": {
                return Optional.ofNullable(clazz.cast(this.taskingDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("taskingDocument", TASKING_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentConfigurationResponse, T> g) {
        return obj -> g.apply((GetAgentConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String agentId;
        private String taskingDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentConfigurationResponse model) {
            super(model);
            this.agentId(model.agentId);
            this.taskingDocument(model.taskingDocument);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getTaskingDocument() {
            return this.taskingDocument;
        }

        public final void setTaskingDocument(String taskingDocument) {
            this.taskingDocument = taskingDocument;
        }

        @Override
        public final Builder taskingDocument(String taskingDocument) {
            this.taskingDocument = taskingDocument;
            return this;
        }

        @Override
        public GetAgentConfigurationResponse build() {
            return new GetAgentConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAgentConfigurationResponse> {
        public Builder agentId(String var1);

        public Builder taskingDocument(String var1);
    }
}

