/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an uplink echo <code>Config</code>.
 * </p>
 * <p>
 * Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified
 * <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UplinkEchoConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UplinkEchoConfig.Builder, UplinkEchoConfig> {
    private static final SdkField<String> ANTENNA_UPLINK_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("antennaUplinkConfigArn").getter(getter(UplinkEchoConfig::antennaUplinkConfigArn))
            .setter(setter(Builder::antennaUplinkConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaUplinkConfigArn").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(UplinkEchoConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANTENNA_UPLINK_CONFIG_ARN_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String antennaUplinkConfigArn;

    private final Boolean enabled;

    private UplinkEchoConfig(BuilderImpl builder) {
        this.antennaUplinkConfigArn = builder.antennaUplinkConfigArn;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * ARN of an uplink <code>Config</code>.
     * </p>
     * 
     * @return ARN of an uplink <code>Config</code>.
     */
    public final String antennaUplinkConfigArn() {
        return antennaUplinkConfigArn;
    }

    /**
     * <p>
     * Whether or not an uplink <code>Config</code> is enabled.
     * </p>
     * 
     * @return Whether or not an uplink <code>Config</code> is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(antennaUplinkConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UplinkEchoConfig)) {
            return false;
        }
        UplinkEchoConfig other = (UplinkEchoConfig) obj;
        return Objects.equals(antennaUplinkConfigArn(), other.antennaUplinkConfigArn())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UplinkEchoConfig").add("AntennaUplinkConfigArn", antennaUplinkConfigArn())
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "antennaUplinkConfigArn":
            return Optional.ofNullable(clazz.cast(antennaUplinkConfigArn()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UplinkEchoConfig, T> g) {
        return obj -> g.apply((UplinkEchoConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UplinkEchoConfig> {
        /**
         * <p>
         * ARN of an uplink <code>Config</code>.
         * </p>
         * 
         * @param antennaUplinkConfigArn
         *        ARN of an uplink <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antennaUplinkConfigArn(String antennaUplinkConfigArn);

        /**
         * <p>
         * Whether or not an uplink <code>Config</code> is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether or not an uplink <code>Config</code> is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String antennaUplinkConfigArn;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UplinkEchoConfig model) {
            antennaUplinkConfigArn(model.antennaUplinkConfigArn);
            enabled(model.enabled);
        }

        public final String getAntennaUplinkConfigArn() {
            return antennaUplinkConfigArn;
        }

        public final void setAntennaUplinkConfigArn(String antennaUplinkConfigArn) {
            this.antennaUplinkConfigArn = antennaUplinkConfigArn;
        }

        @Override
        public final Builder antennaUplinkConfigArn(String antennaUplinkConfigArn) {
            this.antennaUplinkConfigArn = antennaUplinkConfigArn;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public UplinkEchoConfig build() {
            return new UplinkEchoConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
