/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.groundstation.model.CancelContactRequest;
import software.amazon.awssdk.services.groundstation.model.CancelContactResponse;
import software.amazon.awssdk.services.groundstation.model.CreateConfigRequest;
import software.amazon.awssdk.services.groundstation.model.CreateConfigResponse;
import software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteConfigRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.DependencyException;
import software.amazon.awssdk.services.groundstation.model.DescribeContactRequest;
import software.amazon.awssdk.services.groundstation.model.DescribeContactResponse;
import software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest;
import software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse;
import software.amazon.awssdk.services.groundstation.model.GetConfigRequest;
import software.amazon.awssdk.services.groundstation.model.GetConfigResponse;
import software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest;
import software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse;
import software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest;
import software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse;
import software.amazon.awssdk.services.groundstation.model.GroundStationException;
import software.amazon.awssdk.services.groundstation.model.InvalidParameterException;
import software.amazon.awssdk.services.groundstation.model.ListConfigsRequest;
import software.amazon.awssdk.services.groundstation.model.ListConfigsResponse;
import software.amazon.awssdk.services.groundstation.model.ListContactsRequest;
import software.amazon.awssdk.services.groundstation.model.ListContactsResponse;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse;
import software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.groundstation.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest;
import software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse;
import software.amazon.awssdk.services.groundstation.model.ReserveContactRequest;
import software.amazon.awssdk.services.groundstation.model.ReserveContactResponse;
import software.amazon.awssdk.services.groundstation.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.groundstation.model.ResourceNotFoundException;
import software.amazon.awssdk.services.groundstation.model.TagResourceRequest;
import software.amazon.awssdk.services.groundstation.model.TagResourceResponse;
import software.amazon.awssdk.services.groundstation.model.UntagResourceRequest;
import software.amazon.awssdk.services.groundstation.model.UntagResourceResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable;
import software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable;
import software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable;
import software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable;
import software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable;
import software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable;
import software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable;
import software.amazon.awssdk.services.groundstation.waiters.GroundStationWaiter;

/**
 * Service client for accessing AWS Ground Station. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the AWS Ground Station API Reference. AWS Ground Station is a fully managed service that enables you to
 * control satellite communications, downlink and process satellite data, and scale your satellite operations
 * efficiently and cost-effectively without having to build or manage your own ground station infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GroundStationClient extends AwsClient {
    String SERVICE_NAME = "groundstation";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "groundstation";

    /**
     * <p>
     * Cancels a contact with a specified contact ID.
     * </p>
     *
     * @param cancelContactRequest
     * @return Result of the CancelContact operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CancelContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CancelContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelContactResponse cancelContact(CancelContactRequest cancelContactRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a contact with a specified contact ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelContactRequest.Builder} avoiding the need to
     * create one manually via {@link CancelContactRequest#builder()}
     * </p>
     *
     * @param cancelContactRequest
     *        A {@link Consumer} that will call methods on {@link CancelContactRequest.Builder} to create a request.
     * @return Result of the CancelContact operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CancelContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CancelContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelContactResponse cancelContact(Consumer<CancelContactRequest.Builder> cancelContactRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return cancelContact(CancelContactRequest.builder().applyMutation(cancelContactRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Config</code> with the specified <code>configData</code> parameters.
     * </p>
     * <p>
     * Only one type of <code>configData</code> can be specified.
     * </p>
     *
     * @param createConfigRequest
     * @return Result of the CreateConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceLimitExceededException
     *         Account limits for this resource have been exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConfigResponse createConfig(CreateConfigRequest createConfigRequest) throws InvalidParameterException,
            DependencyException, ResourceLimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Config</code> with the specified <code>configData</code> parameters.
     * </p>
     * <p>
     * Only one type of <code>configData</code> can be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigRequest.Builder} avoiding the need to
     * create one manually via {@link CreateConfigRequest#builder()}
     * </p>
     *
     * @param createConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigRequest.Builder} to create a request.
     * @return Result of the CreateConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceLimitExceededException
     *         Account limits for this resource have been exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConfigResponse createConfig(Consumer<CreateConfigRequest.Builder> createConfigRequest)
            throws InvalidParameterException, DependencyException, ResourceLimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, GroundStationException {
        return createConfig(CreateConfigRequest.builder().applyMutation(createConfigRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code>
     * objects.
     * </p>
     * <p>
     * The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code>
     * to specify which endpoints to use during a contact.
     * </p>
     * <p>
     * When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code> must match a
     * <code>DataflowEndpoint</code> in the same group.
     * </p>
     *
     * @param createDataflowEndpointGroupRequest
     * @return Result of the CreateDataflowEndpointGroup operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataflowEndpointGroupResponse createDataflowEndpointGroup(
            CreateDataflowEndpointGroupRequest createDataflowEndpointGroupRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code>
     * objects.
     * </p>
     * <p>
     * The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code>
     * to specify which endpoints to use during a contact.
     * </p>
     * <p>
     * When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code> must match a
     * <code>DataflowEndpoint</code> in the same group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataflowEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataflowEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createDataflowEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataflowEndpointGroupRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDataflowEndpointGroup operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataflowEndpointGroupResponse createDataflowEndpointGroup(
            Consumer<CreateDataflowEndpointGroupRequest.Builder> createDataflowEndpointGroupRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return createDataflowEndpointGroup(CreateDataflowEndpointGroupRequest.builder()
                .applyMutation(createDataflowEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Creates an Ephemeris with the specified <code>EphemerisData</code>.
     * </p>
     *
     * @param createEphemerisRequest
     * @return Result of the CreateEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEphemerisResponse createEphemeris(CreateEphemerisRequest createEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Ephemeris with the specified <code>EphemerisData</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEphemerisRequest#builder()}
     * </p>
     *
     * @param createEphemerisRequest
     *        A {@link Consumer} that will call methods on {@link CreateEphemerisRequest.Builder} to create a request.
     * @return Result of the CreateEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEphemerisResponse createEphemeris(Consumer<CreateEphemerisRequest.Builder> createEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return createEphemeris(CreateEphemerisRequest.builder().applyMutation(createEphemerisRequest).build());
    }

    /**
     * <p>
     * Creates a mission profile.
     * </p>
     * <p>
     * <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings has two elements: a
     * <i>from</i> ARN and a <i>to</i> ARN.
     * </p>
     *
     * @param createMissionProfileRequest
     * @return Result of the CreateMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMissionProfileResponse createMissionProfile(CreateMissionProfileRequest createMissionProfileRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mission profile.
     * </p>
     * <p>
     * <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings has two elements: a
     * <i>from</i> ARN and a <i>to</i> ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMissionProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMissionProfileRequest#builder()}
     * </p>
     *
     * @param createMissionProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateMissionProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.CreateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMissionProfileResponse createMissionProfile(
            Consumer<CreateMissionProfileRequest.Builder> createMissionProfileRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return createMissionProfile(CreateMissionProfileRequest.builder().applyMutation(createMissionProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Config</code>.
     * </p>
     *
     * @param deleteConfigRequest
     * @return Result of the DeleteConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConfigResponse deleteConfig(DeleteConfigRequest deleteConfigRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Config</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteConfigRequest#builder()}
     * </p>
     *
     * @param deleteConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigRequest.Builder} to create a request.
     * @return Result of the DeleteConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConfigResponse deleteConfig(Consumer<DeleteConfigRequest.Builder> deleteConfigRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return deleteConfig(DeleteConfigRequest.builder().applyMutation(deleteConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a dataflow endpoint group.
     * </p>
     *
     * @param deleteDataflowEndpointGroupRequest
     * @return Result of the DeleteDataflowEndpointGroup operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataflowEndpointGroupResponse deleteDataflowEndpointGroup(
            DeleteDataflowEndpointGroupRequest deleteDataflowEndpointGroupRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataflow endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataflowEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataflowEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteDataflowEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataflowEndpointGroupRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDataflowEndpointGroup operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataflowEndpointGroupResponse deleteDataflowEndpointGroup(
            Consumer<DeleteDataflowEndpointGroupRequest.Builder> deleteDataflowEndpointGroupRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return deleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest.builder()
                .applyMutation(deleteDataflowEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an ephemeris
     * </p>
     *
     * @param deleteEphemerisRequest
     * @return Result of the DeleteEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEphemerisResponse deleteEphemeris(DeleteEphemerisRequest deleteEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ephemeris
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEphemerisRequest#builder()}
     * </p>
     *
     * @param deleteEphemerisRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEphemerisRequest.Builder} to create a request.
     * @return Result of the DeleteEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEphemerisResponse deleteEphemeris(Consumer<DeleteEphemerisRequest.Builder> deleteEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return deleteEphemeris(DeleteEphemerisRequest.builder().applyMutation(deleteEphemerisRequest).build());
    }

    /**
     * <p>
     * Deletes a mission profile.
     * </p>
     *
     * @param deleteMissionProfileRequest
     * @return Result of the DeleteMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMissionProfileResponse deleteMissionProfile(DeleteMissionProfileRequest deleteMissionProfileRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a mission profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMissionProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMissionProfileRequest#builder()}
     * </p>
     *
     * @param deleteMissionProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMissionProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DeleteMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMissionProfileResponse deleteMissionProfile(
            Consumer<DeleteMissionProfileRequest.Builder> deleteMissionProfileRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return deleteMissionProfile(DeleteMissionProfileRequest.builder().applyMutation(deleteMissionProfileRequest).build());
    }

    /**
     * <p>
     * Describes an existing contact.
     * </p>
     *
     * @param describeContactRequest
     * @return Result of the DescribeContact operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContactResponse describeContact(DescribeContactRequest describeContactRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContactRequest#builder()}
     * </p>
     *
     * @param describeContactRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContactRequest.Builder} to create a request.
     * @return Result of the DescribeContact operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContactResponse describeContact(Consumer<DescribeContactRequest.Builder> describeContactRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return describeContact(DescribeContactRequest.builder().applyMutation(describeContactRequest).build());
    }

    /**
     * <p>
     * Describes an existing ephemeris.
     * </p>
     *
     * @param describeEphemerisRequest
     * @return Result of the DescribeEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DescribeEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeEphemeris"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEphemerisResponse describeEphemeris(DescribeEphemerisRequest describeEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing ephemeris.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEphemerisRequest#builder()}
     * </p>
     *
     * @param describeEphemerisRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEphemerisRequest.Builder} to create a request.
     * @return Result of the DescribeEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.DescribeEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeEphemeris"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEphemerisResponse describeEphemeris(Consumer<DescribeEphemerisRequest.Builder> describeEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return describeEphemeris(DescribeEphemerisRequest.builder().applyMutation(describeEphemerisRequest).build());
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Gets the latest configuration information for a registered agent.
     * </p>
     *
     * @param getAgentConfigurationRequest
     * @return Result of the GetAgentConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetAgentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetAgentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentConfigurationResponse getAgentConfiguration(GetAgentConfigurationRequest getAgentConfigurationRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Gets the latest configuration information for a registered agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetAgentConfigurationRequest#builder()}
     * </p>
     *
     * @param getAgentConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetAgentConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetAgentConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetAgentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetAgentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentConfigurationResponse getAgentConfiguration(
            Consumer<GetAgentConfigurationRequest.Builder> getAgentConfigurationRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return getAgentConfiguration(GetAgentConfigurationRequest.builder().applyMutation(getAgentConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns <code>Config</code> information.
     * </p>
     * <p>
     * Only one <code>Config</code> response can be returned.
     * </p>
     *
     * @param getConfigRequest
     * @return Result of the GetConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConfigResponse getConfig(GetConfigRequest getConfigRequest) throws InvalidParameterException, DependencyException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns <code>Config</code> information.
     * </p>
     * <p>
     * Only one <code>Config</code> response can be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigRequest.Builder} avoiding the need to
     * create one manually via {@link GetConfigRequest#builder()}
     * </p>
     *
     * @param getConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigRequest.Builder} to create a request.
     * @return Result of the GetConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConfigResponse getConfig(Consumer<GetConfigRequest.Builder> getConfigRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return getConfig(GetConfigRequest.builder().applyMutation(getConfigRequest).build());
    }

    /**
     * <p>
     * Returns the dataflow endpoint group.
     * </p>
     *
     * @param getDataflowEndpointGroupRequest
     * @return Result of the GetDataflowEndpointGroup operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataflowEndpointGroupResponse getDataflowEndpointGroup(
            GetDataflowEndpointGroupRequest getDataflowEndpointGroupRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the dataflow endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataflowEndpointGroupRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataflowEndpointGroupRequest#builder()}
     * </p>
     *
     * @param getDataflowEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetDataflowEndpointGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetDataflowEndpointGroup operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataflowEndpointGroupResponse getDataflowEndpointGroup(
            Consumer<GetDataflowEndpointGroupRequest.Builder> getDataflowEndpointGroupRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return getDataflowEndpointGroup(GetDataflowEndpointGroupRequest.builder().applyMutation(getDataflowEndpointGroupRequest)
                .build());
    }

    /**
     * <p>
     * Returns the number of minutes used by account.
     * </p>
     *
     * @param getMinuteUsageRequest
     * @return Result of the GetMinuteUsage operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetMinuteUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMinuteUsage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMinuteUsageResponse getMinuteUsage(GetMinuteUsageRequest getMinuteUsageRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of minutes used by account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMinuteUsageRequest.Builder} avoiding the need to
     * create one manually via {@link GetMinuteUsageRequest#builder()}
     * </p>
     *
     * @param getMinuteUsageRequest
     *        A {@link Consumer} that will call methods on {@link GetMinuteUsageRequest.Builder} to create a request.
     * @return Result of the GetMinuteUsage operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetMinuteUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMinuteUsage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMinuteUsageResponse getMinuteUsage(Consumer<GetMinuteUsageRequest.Builder> getMinuteUsageRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return getMinuteUsage(GetMinuteUsageRequest.builder().applyMutation(getMinuteUsageRequest).build());
    }

    /**
     * <p>
     * Returns a mission profile.
     * </p>
     *
     * @param getMissionProfileRequest
     * @return Result of the GetMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMissionProfileResponse getMissionProfile(GetMissionProfileRequest getMissionProfileRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a mission profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMissionProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetMissionProfileRequest#builder()}
     * </p>
     *
     * @param getMissionProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetMissionProfileRequest.Builder} to create a request.
     * @return Result of the GetMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMissionProfileResponse getMissionProfile(Consumer<GetMissionProfileRequest.Builder> getMissionProfileRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return getMissionProfile(GetMissionProfileRequest.builder().applyMutation(getMissionProfileRequest).build());
    }

    /**
     * <p>
     * Returns a satellite.
     * </p>
     *
     * @param getSatelliteRequest
     * @return Result of the GetSatellite operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetSatellite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetSatellite" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSatelliteResponse getSatellite(GetSatelliteRequest getSatelliteRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a satellite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSatelliteRequest.Builder} avoiding the need to
     * create one manually via {@link GetSatelliteRequest#builder()}
     * </p>
     *
     * @param getSatelliteRequest
     *        A {@link Consumer} that will call methods on {@link GetSatelliteRequest.Builder} to create a request.
     * @return Result of the GetSatellite operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.GetSatellite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetSatellite" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSatelliteResponse getSatellite(Consumer<GetSatelliteRequest.Builder> getSatelliteRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return getSatellite(GetSatelliteRequest.builder().applyMutation(getSatelliteRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>Config</code> objects.
     * </p>
     *
     * @param listConfigsRequest
     * @return Result of the ListConfigs operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigsResponse listConfigs(ListConfigsRequest listConfigsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>Config</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConfigsRequest#builder()}
     * </p>
     *
     * @param listConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigsRequest.Builder} to create a request.
     * @return Result of the ListConfigs operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigsResponse listConfigs(Consumer<ListConfigsRequest.Builder> listConfigsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listConfigs(ListConfigsRequest.builder().applyMutation(listConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>Config</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable responses = client.listConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable responses = client.listConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable responses = client.listConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)} operation.</b>
     * </p>
     *
     * @param listConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigsIterable listConfigsPaginator(ListConfigsRequest listConfigsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>Config</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable responses = client.listConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable responses = client.listConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsIterable responses = client.listConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConfigsRequest#builder()}
     * </p>
     *
     * @param listConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigsIterable listConfigsPaginator(Consumer<ListConfigsRequest.Builder> listConfigsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listConfigsPaginator(ListConfigsRequest.builder().applyMutation(listConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of contacts.
     * </p>
     * <p>
     * If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>,
     * <code>missionprofileArn</code>, and <code>satelliteArn</code>.
     * </p>
     *
     * @param listContactsRequest
     * @return Result of the ListContacts operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactsResponse listContacts(ListContactsRequest listContactsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of contacts.
     * </p>
     * <p>
     * If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>,
     * <code>missionprofileArn</code>, and <code>satelliteArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactsRequest.Builder} to create a request.
     * @return Result of the ListContacts operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactsResponse listContacts(Consumer<ListContactsRequest.Builder> listContactsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listContacts(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Returns a list of contacts.
     * </p>
     * <p>
     * If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>,
     * <code>missionprofileArn</code>, and <code>satelliteArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable responses = client
     *             .listContactsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation.</b>
     * </p>
     *
     * @param listContactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactsIterable listContactsPaginator(ListContactsRequest listContactsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of contacts.
     * </p>
     * <p>
     * If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>,
     * <code>missionprofileArn</code>, and <code>satelliteArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable responses = client
     *             .listContactsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactsIterable listContactsPaginator(Consumer<ListContactsRequest.Builder> listContactsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listContactsPaginator(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DataflowEndpoint</code> groups.
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     * @return Result of the ListDataflowEndpointGroups operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataflowEndpointGroupsResponse listDataflowEndpointGroups(
            ListDataflowEndpointGroupsRequest listDataflowEndpointGroupsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DataflowEndpoint</code> groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataflowEndpointGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataflowEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataflowEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataflowEndpointGroups operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataflowEndpointGroupsResponse listDataflowEndpointGroups(
            Consumer<ListDataflowEndpointGroupsRequest.Builder> listDataflowEndpointGroupsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listDataflowEndpointGroups(ListDataflowEndpointGroupsRequest.builder()
                .applyMutation(listDataflowEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DataflowEndpoint</code> groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable responses = client.listDataflowEndpointGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable responses = client
     *             .listDataflowEndpointGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable responses = client.listDataflowEndpointGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataflowEndpointGroupsIterable listDataflowEndpointGroupsPaginator(
            ListDataflowEndpointGroupsRequest listDataflowEndpointGroupsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DataflowEndpoint</code> groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable responses = client.listDataflowEndpointGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable responses = client
     *             .listDataflowEndpointGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsIterable responses = client.listDataflowEndpointGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataflowEndpointGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataflowEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataflowEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataflowEndpointGroupsIterable listDataflowEndpointGroupsPaginator(
            Consumer<ListDataflowEndpointGroupsRequest.Builder> listDataflowEndpointGroupsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listDataflowEndpointGroupsPaginator(ListDataflowEndpointGroupsRequest.builder()
                .applyMutation(listDataflowEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List existing ephemerides.
     * </p>
     *
     * @param listEphemeridesRequest
     * @return Result of the ListEphemerides operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEphemeridesResponse listEphemerides(ListEphemeridesRequest listEphemeridesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List existing ephemerides.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEphemeridesRequest.Builder} avoiding the need
     * to create one manually via {@link ListEphemeridesRequest#builder()}
     * </p>
     *
     * @param listEphemeridesRequest
     *        A {@link Consumer} that will call methods on {@link ListEphemeridesRequest.Builder} to create a request.
     * @return Result of the ListEphemerides operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEphemeridesResponse listEphemerides(Consumer<ListEphemeridesRequest.Builder> listEphemeridesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listEphemerides(ListEphemeridesRequest.builder().applyMutation(listEphemeridesRequest).build());
    }

    /**
     * <p>
     * List existing ephemerides.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable responses = client.listEphemeridesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable responses = client
     *             .listEphemeridesPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable responses = client.listEphemeridesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEphemeridesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEphemeridesIterable listEphemeridesPaginator(ListEphemeridesRequest listEphemeridesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List existing ephemerides.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable responses = client.listEphemeridesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable responses = client
     *             .listEphemeridesPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesIterable responses = client.listEphemeridesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEphemeridesRequest.Builder} avoiding the need
     * to create one manually via {@link ListEphemeridesRequest#builder()}
     * </p>
     *
     * @param listEphemeridesRequest
     *        A {@link Consumer} that will call methods on {@link ListEphemeridesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEphemeridesIterable listEphemeridesPaginator(Consumer<ListEphemeridesRequest.Builder> listEphemeridesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listEphemeridesPaginator(ListEphemeridesRequest.builder().applyMutation(listEphemeridesRequest).build());
    }

    /**
     * <p>
     * Returns a list of ground stations.
     * </p>
     *
     * @param listGroundStationsRequest
     * @return Result of the ListGroundStations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroundStationsResponse listGroundStations(ListGroundStationsRequest listGroundStationsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ground stations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroundStationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroundStationsRequest#builder()}
     * </p>
     *
     * @param listGroundStationsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroundStationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListGroundStations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroundStationsResponse listGroundStations(Consumer<ListGroundStationsRequest.Builder> listGroundStationsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listGroundStations(ListGroundStationsRequest.builder().applyMutation(listGroundStationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ground stations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable responses = client.listGroundStationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable responses = client
     *             .listGroundStationsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable responses = client.listGroundStationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroundStationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroundStationsIterable listGroundStationsPaginator(ListGroundStationsRequest listGroundStationsRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ground stations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable responses = client.listGroundStationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable responses = client
     *             .listGroundStationsPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsIterable responses = client.listGroundStationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroundStationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroundStationsRequest#builder()}
     * </p>
     *
     * @param listGroundStationsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroundStationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroundStationsIterable listGroundStationsPaginator(
            Consumer<ListGroundStationsRequest.Builder> listGroundStationsRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return listGroundStationsPaginator(ListGroundStationsRequest.builder().applyMutation(listGroundStationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of mission profiles.
     * </p>
     *
     * @param listMissionProfilesRequest
     * @return Result of the ListMissionProfiles operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMissionProfilesResponse listMissionProfiles(ListMissionProfilesRequest listMissionProfilesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of mission profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMissionProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMissionProfilesRequest#builder()}
     * </p>
     *
     * @param listMissionProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListMissionProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListMissionProfiles operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMissionProfilesResponse listMissionProfiles(
            Consumer<ListMissionProfilesRequest.Builder> listMissionProfilesRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return listMissionProfiles(ListMissionProfilesRequest.builder().applyMutation(listMissionProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of mission profiles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable responses = client.listMissionProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable responses = client
     *             .listMissionProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable responses = client.listMissionProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMissionProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMissionProfilesIterable listMissionProfilesPaginator(ListMissionProfilesRequest listMissionProfilesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of mission profiles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable responses = client.listMissionProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable responses = client
     *             .listMissionProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesIterable responses = client.listMissionProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMissionProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMissionProfilesRequest#builder()}
     * </p>
     *
     * @param listMissionProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListMissionProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMissionProfilesIterable listMissionProfilesPaginator(
            Consumer<ListMissionProfilesRequest.Builder> listMissionProfilesRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return listMissionProfilesPaginator(ListMissionProfilesRequest.builder().applyMutation(listMissionProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of satellites.
     * </p>
     *
     * @param listSatellitesRequest
     * @return Result of the ListSatellites operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSatellitesResponse listSatellites(ListSatellitesRequest listSatellitesRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of satellites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSatellitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSatellitesRequest#builder()}
     * </p>
     *
     * @param listSatellitesRequest
     *        A {@link Consumer} that will call methods on {@link ListSatellitesRequest.Builder} to create a request.
     * @return Result of the ListSatellites operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSatellitesResponse listSatellites(Consumer<ListSatellitesRequest.Builder> listSatellitesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listSatellites(ListSatellitesRequest.builder().applyMutation(listSatellitesRequest).build());
    }

    /**
     * <p>
     * Returns a list of satellites.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable responses = client.listSatellitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable responses = client
     *             .listSatellitesPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable responses = client.listSatellitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation.</b>
     * </p>
     *
     * @param listSatellitesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSatellitesIterable listSatellitesPaginator(ListSatellitesRequest listSatellitesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of satellites.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable responses = client.listSatellitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable responses = client
     *             .listSatellitesPaginator(request);
     *     for (software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesIterable responses = client.listSatellitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSatellitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSatellitesRequest#builder()}
     * </p>
     *
     * @param listSatellitesRequest
     *        A {@link Consumer} that will call methods on {@link ListSatellitesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSatellitesIterable listSatellitesPaginator(Consumer<ListSatellitesRequest.Builder> listSatellitesRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return listSatellitesPaginator(ListSatellitesRequest.builder().applyMutation(listSatellitesRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Registers a new agent with AWS Ground Station.
     * </p>
     *
     * @param registerAgentRequest
     * @return Result of the RegisterAgent operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.RegisterAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/RegisterAgent" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterAgentResponse registerAgent(RegisterAgentRequest registerAgentRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Registers a new agent with AWS Ground Station.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAgentRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterAgentRequest#builder()}
     * </p>
     *
     * @param registerAgentRequest
     *        A {@link Consumer} that will call methods on {@link RegisterAgentRequest.Builder} to create a request.
     * @return Result of the RegisterAgent operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.RegisterAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/RegisterAgent" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterAgentResponse registerAgent(Consumer<RegisterAgentRequest.Builder> registerAgentRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return registerAgent(RegisterAgentRequest.builder().applyMutation(registerAgentRequest).build());
    }

    /**
     * <p>
     * Reserves a contact using specified parameters.
     * </p>
     *
     * @param reserveContactRequest
     * @return Result of the ReserveContact operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ReserveContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ReserveContact" target="_top">AWS
     *      API Documentation</a>
     */
    default ReserveContactResponse reserveContact(ReserveContactRequest reserveContactRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reserves a contact using specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReserveContactRequest.Builder} avoiding the need to
     * create one manually via {@link ReserveContactRequest#builder()}
     * </p>
     *
     * @param reserveContactRequest
     *        A {@link Consumer} that will call methods on {@link ReserveContactRequest.Builder} to create a request.
     * @return Result of the ReserveContact operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.ReserveContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ReserveContact" target="_top">AWS
     *      API Documentation</a>
     */
    default ReserveContactResponse reserveContact(Consumer<ReserveContactRequest.Builder> reserveContactRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return reserveContact(ReserveContactRequest.builder().applyMutation(reserveContactRequest).build());
    }

    /**
     * <p>
     * Assigns a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deassigns a resource tag.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deassigns a resource tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Update the status of the agent.
     * </p>
     *
     * @param updateAgentStatusRequest
     * @return Result of the UpdateAgentStatus operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateAgentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAgentStatusResponse updateAgentStatus(UpdateAgentStatusRequest updateAgentStatusRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Update the status of the agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentStatusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAgentStatusRequest#builder()}
     * </p>
     *
     * @param updateAgentStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAgentStatusRequest.Builder} to create a request.
     * @return Result of the UpdateAgentStatus operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateAgentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAgentStatusResponse updateAgentStatus(Consumer<UpdateAgentStatusRequest.Builder> updateAgentStatusRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return updateAgentStatus(UpdateAgentStatusRequest.builder().applyMutation(updateAgentStatusRequest).build());
    }

    /**
     * <p>
     * Updates the <code>Config</code> used when scheduling contacts.
     * </p>
     * <p>
     * Updating a <code>Config</code> will not update the execution parameters for existing future contacts scheduled
     * with this <code>Config</code>.
     * </p>
     *
     * @param updateConfigRequest
     * @return Result of the UpdateConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateConfigResponse updateConfig(UpdateConfigRequest updateConfigRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>Config</code> used when scheduling contacts.
     * </p>
     * <p>
     * Updating a <code>Config</code> will not update the execution parameters for existing future contacts scheduled
     * with this <code>Config</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateConfigRequest#builder()}
     * </p>
     *
     * @param updateConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigRequest.Builder} to create a request.
     * @return Result of the UpdateConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateConfigResponse updateConfig(Consumer<UpdateConfigRequest.Builder> updateConfigRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return updateConfig(UpdateConfigRequest.builder().applyMutation(updateConfigRequest).build());
    }

    /**
     * <p>
     * Updates an existing ephemeris
     * </p>
     *
     * @param updateEphemerisRequest
     * @return Result of the UpdateEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEphemerisResponse updateEphemeris(UpdateEphemerisRequest updateEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing ephemeris
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEphemerisRequest#builder()}
     * </p>
     *
     * @param updateEphemerisRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEphemerisRequest.Builder} to create a request.
     * @return Result of the UpdateEphemeris operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEphemerisResponse updateEphemeris(Consumer<UpdateEphemerisRequest.Builder> updateEphemerisRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        return updateEphemeris(UpdateEphemerisRequest.builder().applyMutation(updateEphemerisRequest).build());
    }

    /**
     * <p>
     * Updates a mission profile.
     * </p>
     * <p>
     * Updating a mission profile will not update the execution parameters for existing future contacts.
     * </p>
     *
     * @param updateMissionProfileRequest
     * @return Result of the UpdateMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMissionProfileResponse updateMissionProfile(UpdateMissionProfileRequest updateMissionProfileRequest)
            throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, GroundStationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a mission profile.
     * </p>
     * <p>
     * Updating a mission profile will not update the execution parameters for existing future contacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMissionProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMissionProfileRequest#builder()}
     * </p>
     *
     * @param updateMissionProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMissionProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMissionProfile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GroundStationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GroundStationClient.UpdateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMissionProfileResponse updateMissionProfile(
            Consumer<UpdateMissionProfileRequest.Builder> updateMissionProfileRequest) throws InvalidParameterException,
            DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        return updateMissionProfile(UpdateMissionProfileRequest.builder().applyMutation(updateMissionProfileRequest).build());
    }

    /**
     * Create an instance of {@link GroundStationWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link GroundStationWaiter}
     */
    default GroundStationWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GroundStationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GroundStationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GroundStationClient}.
     */
    static GroundStationClientBuilder builder() {
        return new DefaultGroundStationClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default GroundStationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
