/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ComponentVersion;
import software.amazon.awssdk.services.groundstation.model.ComponentVersionListCopier;
import software.amazon.awssdk.services.groundstation.model.ReservedCpuCoresListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentDetails> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(AgentDetails.getter(AgentDetails::agentVersion)).setter(AgentDetails.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final SdkField<List<ComponentVersion>> COMPONENT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentVersions").getter(AgentDetails.getter(AgentDetails::componentVersions)).setter(AgentDetails.setter(Builder::componentVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(AgentDetails.getter(AgentDetails::instanceId)).setter(AgentDetails.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(AgentDetails.getter(AgentDetails::instanceType)).setter(AgentDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<List<Integer>> RESERVED_CPU_CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reservedCpuCores").getter(AgentDetails.getter(AgentDetails::reservedCpuCores)).setter(AgentDetails.setter(Builder::reservedCpuCores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedCpuCores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD, COMPONENT_VERSIONS_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, RESERVED_CPU_CORES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentVersion;
    private final List<ComponentVersion> componentVersions;
    private final String instanceId;
    private final String instanceType;
    private final List<Integer> reservedCpuCores;

    private AgentDetails(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.componentVersions = builder.componentVersions;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.reservedCpuCores = builder.reservedCpuCores;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final boolean hasComponentVersions() {
        return this.componentVersions != null && !(this.componentVersions instanceof SdkAutoConstructList);
    }

    public final List<ComponentVersion> componentVersions() {
        return this.componentVersions;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final boolean hasReservedCpuCores() {
        return this.reservedCpuCores != null && !(this.reservedCpuCores instanceof SdkAutoConstructList);
    }

    public final List<Integer> reservedCpuCores() {
        return this.reservedCpuCores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentVersions() ? this.componentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedCpuCores() ? this.reservedCpuCores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentDetails)) {
            return false;
        }
        AgentDetails other = (AgentDetails)obj;
        return Objects.equals(this.agentVersion(), other.agentVersion()) && this.hasComponentVersions() == other.hasComponentVersions() && Objects.equals(this.componentVersions(), other.componentVersions()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && this.hasReservedCpuCores() == other.hasReservedCpuCores() && Objects.equals(this.reservedCpuCores(), other.reservedCpuCores());
    }

    public final String toString() {
        return ToString.builder((String)"AgentDetails").add("AgentVersion", (Object)this.agentVersion()).add("ComponentVersions", this.hasComponentVersions() ? this.componentVersions() : null).add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("ReservedCpuCores", this.hasReservedCpuCores() ? this.reservedCpuCores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "componentVersions": {
                return Optional.ofNullable(clazz.cast(this.componentVersions()));
            }
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "reservedCpuCores": {
                return Optional.ofNullable(clazz.cast(this.reservedCpuCores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentDetails, T> g) {
        return obj -> g.apply((AgentDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentVersion;
        private List<ComponentVersion> componentVersions = DefaultSdkAutoConstructList.getInstance();
        private String instanceId;
        private String instanceType;
        private List<Integer> reservedCpuCores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentDetails model) {
            this.agentVersion(model.agentVersion);
            this.componentVersions(model.componentVersions);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.reservedCpuCores(model.reservedCpuCores);
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final List<ComponentVersion.Builder> getComponentVersions() {
            List<ComponentVersion.Builder> result = ComponentVersionListCopier.copyToBuilder(this.componentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentVersions(Collection<ComponentVersion.BuilderImpl> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copyFromBuilder(componentVersions);
        }

        @Override
        public final Builder componentVersions(Collection<ComponentVersion> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copy(componentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(ComponentVersion ... componentVersions) {
            this.componentVersions(Arrays.asList(componentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(Consumer<ComponentVersion.Builder> ... componentVersions) {
            this.componentVersions(Stream.of(componentVersions).map(c -> (ComponentVersion)((ComponentVersion.Builder)ComponentVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Collection<Integer> getReservedCpuCores() {
            if (this.reservedCpuCores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedCpuCores;
        }

        public final void setReservedCpuCores(Collection<Integer> reservedCpuCores) {
            this.reservedCpuCores = ReservedCpuCoresListCopier.copy(reservedCpuCores);
        }

        @Override
        public final Builder reservedCpuCores(Collection<Integer> reservedCpuCores) {
            this.reservedCpuCores = ReservedCpuCoresListCopier.copy(reservedCpuCores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCpuCores(Integer ... reservedCpuCores) {
            this.reservedCpuCores(Arrays.asList(reservedCpuCores));
            return this;
        }

        public AgentDetails build() {
            return new AgentDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentDetails> {
        public Builder agentVersion(String var1);

        public Builder componentVersions(Collection<ComponentVersion> var1);

        public Builder componentVersions(ComponentVersion ... var1);

        public Builder componentVersions(Consumer<ComponentVersion.Builder> ... var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder reservedCpuCores(Collection<Integer> var1);

        public Builder reservedCpuCores(Integer ... var1);
    }
}

