/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAgentRequest extends GroundStationRequest implements
        ToCopyableBuilder<RegisterAgentRequest.Builder, RegisterAgentRequest> {
    private static final SdkField<AgentDetails> AGENT_DETAILS_FIELD = SdkField.<AgentDetails> builder(MarshallingType.SDK_POJO)
            .memberName("agentDetails").getter(getter(RegisterAgentRequest::agentDetails)).setter(setter(Builder::agentDetails))
            .constructor(AgentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDetails").build()).build();

    private static final SdkField<DiscoveryData> DISCOVERY_DATA_FIELD = SdkField
            .<DiscoveryData> builder(MarshallingType.SDK_POJO).memberName("discoveryData")
            .getter(getter(RegisterAgentRequest::discoveryData)).setter(setter(Builder::discoveryData))
            .constructor(DiscoveryData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_DETAILS_FIELD,
            DISCOVERY_DATA_FIELD));

    private final AgentDetails agentDetails;

    private final DiscoveryData discoveryData;

    private RegisterAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentDetails = builder.agentDetails;
        this.discoveryData = builder.discoveryData;
    }

    /**
     * <p>
     * Detailed information about the agent being registered.
     * </p>
     * 
     * @return Detailed information about the agent being registered.
     */
    public final AgentDetails agentDetails() {
        return agentDetails;
    }

    /**
     * <p>
     * Data for associating and agent with the capabilities it is managing.
     * </p>
     * 
     * @return Data for associating and agent with the capabilities it is managing.
     */
    public final DiscoveryData discoveryData() {
        return discoveryData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAgentRequest)) {
            return false;
        }
        RegisterAgentRequest other = (RegisterAgentRequest) obj;
        return Objects.equals(agentDetails(), other.agentDetails()) && Objects.equals(discoveryData(), other.discoveryData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAgentRequest").add("AgentDetails", agentDetails()).add("DiscoveryData", discoveryData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentDetails":
            return Optional.ofNullable(clazz.cast(agentDetails()));
        case "discoveryData":
            return Optional.ofNullable(clazz.cast(discoveryData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAgentRequest, T> g) {
        return obj -> g.apply((RegisterAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAgentRequest> {
        /**
         * <p>
         * Detailed information about the agent being registered.
         * </p>
         * 
         * @param agentDetails
         *        Detailed information about the agent being registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentDetails(AgentDetails agentDetails);

        /**
         * <p>
         * Detailed information about the agent being registered.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentDetails.Builder} avoiding the need
         * to create one manually via {@link AgentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #agentDetails(AgentDetails)}.
         * 
         * @param agentDetails
         *        a consumer that will call methods on {@link AgentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentDetails(AgentDetails)
         */
        default Builder agentDetails(Consumer<AgentDetails.Builder> agentDetails) {
            return agentDetails(AgentDetails.builder().applyMutation(agentDetails).build());
        }

        /**
         * <p>
         * Data for associating and agent with the capabilities it is managing.
         * </p>
         * 
         * @param discoveryData
         *        Data for associating and agent with the capabilities it is managing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryData(DiscoveryData discoveryData);

        /**
         * <p>
         * Data for associating and agent with the capabilities it is managing.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiscoveryData.Builder} avoiding the need
         * to create one manually via {@link DiscoveryData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiscoveryData.Builder#build()} is called immediately and its
         * result is passed to {@link #discoveryData(DiscoveryData)}.
         * 
         * @param discoveryData
         *        a consumer that will call methods on {@link DiscoveryData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #discoveryData(DiscoveryData)
         */
        default Builder discoveryData(Consumer<DiscoveryData.Builder> discoveryData) {
            return discoveryData(DiscoveryData.builder().applyMutation(discoveryData).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private AgentDetails agentDetails;

        private DiscoveryData discoveryData;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAgentRequest model) {
            super(model);
            agentDetails(model.agentDetails);
            discoveryData(model.discoveryData);
        }

        public final AgentDetails.Builder getAgentDetails() {
            return agentDetails != null ? agentDetails.toBuilder() : null;
        }

        public final void setAgentDetails(AgentDetails.BuilderImpl agentDetails) {
            this.agentDetails = agentDetails != null ? agentDetails.build() : null;
        }

        @Override
        public final Builder agentDetails(AgentDetails agentDetails) {
            this.agentDetails = agentDetails;
            return this;
        }

        public final DiscoveryData.Builder getDiscoveryData() {
            return discoveryData != null ? discoveryData.toBuilder() : null;
        }

        public final void setDiscoveryData(DiscoveryData.BuilderImpl discoveryData) {
            this.discoveryData = discoveryData != null ? discoveryData.build() : null;
        }

        @Override
        public final Builder discoveryData(DiscoveryData discoveryData) {
            this.discoveryData = discoveryData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAgentRequest build() {
            return new RegisterAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
