/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the ground station data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroundStationData implements SdkPojo, Serializable,
        ToCopyableBuilder<GroundStationData.Builder, GroundStationData> {
    private static final SdkField<String> GROUND_STATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groundStationId").getter(getter(GroundStationData::groundStationId))
            .setter(setter(Builder::groundStationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStationId").build()).build();

    private static final SdkField<String> GROUND_STATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groundStationName").getter(getter(GroundStationData::groundStationName))
            .setter(setter(Builder::groundStationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStationName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GroundStationData::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_STATION_ID_FIELD,
            GROUND_STATION_NAME_FIELD, REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groundStationId;

    private final String groundStationName;

    private final String region;

    private GroundStationData(BuilderImpl builder) {
        this.groundStationId = builder.groundStationId;
        this.groundStationName = builder.groundStationName;
        this.region = builder.region;
    }

    /**
     * <p>
     * UUID of a ground station.
     * </p>
     * 
     * @return UUID of a ground station.
     */
    public final String groundStationId() {
        return groundStationId;
    }

    /**
     * <p>
     * Name of a ground station.
     * </p>
     * 
     * @return Name of a ground station.
     */
    public final String groundStationName() {
        return groundStationName;
    }

    /**
     * <p>
     * Ground station Region.
     * </p>
     * 
     * @return Ground station Region.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groundStationId());
        hashCode = 31 * hashCode + Objects.hashCode(groundStationName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroundStationData)) {
            return false;
        }
        GroundStationData other = (GroundStationData) obj;
        return Objects.equals(groundStationId(), other.groundStationId())
                && Objects.equals(groundStationName(), other.groundStationName()) && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroundStationData").add("GroundStationId", groundStationId())
                .add("GroundStationName", groundStationName()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groundStationId":
            return Optional.ofNullable(clazz.cast(groundStationId()));
        case "groundStationName":
            return Optional.ofNullable(clazz.cast(groundStationName()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroundStationData, T> g) {
        return obj -> g.apply((GroundStationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroundStationData> {
        /**
         * <p>
         * UUID of a ground station.
         * </p>
         * 
         * @param groundStationId
         *        UUID of a ground station.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStationId(String groundStationId);

        /**
         * <p>
         * Name of a ground station.
         * </p>
         * 
         * @param groundStationName
         *        Name of a ground station.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStationName(String groundStationName);

        /**
         * <p>
         * Ground station Region.
         * </p>
         * 
         * @param region
         *        Ground station Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String groundStationId;

        private String groundStationName;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(GroundStationData model) {
            groundStationId(model.groundStationId);
            groundStationName(model.groundStationName);
            region(model.region);
        }

        public final String getGroundStationId() {
            return groundStationId;
        }

        public final void setGroundStationId(String groundStationId) {
            this.groundStationId = groundStationId;
        }

        @Override
        public final Builder groundStationId(String groundStationId) {
            this.groundStationId = groundStationId;
            return this;
        }

        public final String getGroundStationName() {
            return groundStationName;
        }

        public final void setGroundStationName(String groundStationName) {
            this.groundStationName = groundStationName;
        }

        @Override
        public final Builder groundStationName(String groundStationName) {
            this.groundStationName = groundStationName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public GroundStationData build() {
            return new GroundStationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
