/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Ephemeris item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisItem implements SdkPojo, Serializable, ToCopyableBuilder<EphemerisItem.Builder, EphemerisItem> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(EphemerisItem::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(EphemerisItem::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisId").getter(getter(EphemerisItem::ephemerisId)).setter(setter(Builder::ephemerisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EphemerisItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(EphemerisItem::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<S3Object> SOURCE_S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("sourceS3Object").getter(getter(EphemerisItem::sourceS3Object)).setter(setter(Builder::sourceS3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3Object").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EphemerisItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            ENABLED_FIELD, EPHEMERIS_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, SOURCE_S3_OBJECT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final Boolean enabled;

    private final String ephemerisId;

    private final String name;

    private final Integer priority;

    private final S3Object sourceS3Object;

    private final String status;

    private EphemerisItem(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.enabled = builder.enabled;
        this.ephemerisId = builder.ephemerisId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.sourceS3Object = builder.sourceS3Object;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time the ephemeris was uploaded in UTC.
     * </p>
     * 
     * @return The time the ephemeris was uploaded in UTC.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Whether or not the ephemeris is enabled.
     * </p>
     * 
     * @return Whether or not the ephemeris is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The AWS Ground Station ephemeris ID.
     * </p>
     * 
     * @return The AWS Ground Station ephemeris ID.
     */
    public final String ephemerisId() {
        return ephemerisId;
    }

    /**
     * <p>
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     * </p>
     * 
     * @return A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     * </p>
     * <p>
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     * </p>
     * <p>
     * Priority must be 1 or greater
     * </p>
     * 
     * @return Customer-provided priority score to establish the order in which overlapping ephemerides should be
     *         used.</p>
     *         <p>
     *         The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *         </p>
     *         <p>
     *         Priority must be 1 or greater
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Source S3 object used for the ephemeris.
     * </p>
     * 
     * @return Source S3 object used for the ephemeris.
     */
    public final S3Object sourceS3Object() {
        return sourceS3Object;
    }

    /**
     * <p>
     * The status of the ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EphemerisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ephemeris.
     * @see EphemerisStatus
     */
    public final EphemerisStatus status() {
        return EphemerisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EphemerisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ephemeris.
     * @see EphemerisStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisItem)) {
            return false;
        }
        EphemerisItem other = (EphemerisItem) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(ephemerisId(), other.ephemerisId()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(sourceS3Object(), other.sourceS3Object())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisItem").add("CreationTime", creationTime()).add("Enabled", enabled())
                .add("EphemerisId", ephemerisId()).add("Name", name()).add("Priority", priority())
                .add("SourceS3Object", sourceS3Object()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ephemerisId":
            return Optional.ofNullable(clazz.cast(ephemerisId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "sourceS3Object":
            return Optional.ofNullable(clazz.cast(sourceS3Object()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EphemerisItem, T> g) {
        return obj -> g.apply((EphemerisItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisItem> {
        /**
         * <p>
         * The time the ephemeris was uploaded in UTC.
         * </p>
         * 
         * @param creationTime
         *        The time the ephemeris was uploaded in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Whether or not the ephemeris is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether or not the ephemeris is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The AWS Ground Station ephemeris ID.
         * </p>
         * 
         * @param ephemerisId
         *        The AWS Ground Station ephemeris ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisId(String ephemerisId);

        /**
         * <p>
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * </p>
         * 
         * @param name
         *        A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         * </p>
         * <p>
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         * </p>
         * <p>
         * Priority must be 1 or greater
         * </p>
         * 
         * @param priority
         *        Customer-provided priority score to establish the order in which overlapping ephemerides should be
         *        used.</p>
         *        <p>
         *        The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *        </p>
         *        <p>
         *        Priority must be 1 or greater
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Source S3 object used for the ephemeris.
         * </p>
         * 
         * @param sourceS3Object
         *        Source S3 object used for the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Object(S3Object sourceS3Object);

        /**
         * <p>
         * Source S3 object used for the ephemeris.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3Object(S3Object)}.
         * 
         * @param sourceS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Object(S3Object)
         */
        default Builder sourceS3Object(Consumer<S3Object.Builder> sourceS3Object) {
            return sourceS3Object(S3Object.builder().applyMutation(sourceS3Object).build());
        }

        /**
         * <p>
         * The status of the ephemeris.
         * </p>
         * 
         * @param status
         *        The status of the ephemeris.
         * @see EphemerisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ephemeris.
         * </p>
         * 
         * @param status
         *        The status of the ephemeris.
         * @see EphemerisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisStatus
         */
        Builder status(EphemerisStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private Boolean enabled;

        private String ephemerisId;

        private String name;

        private Integer priority;

        private S3Object sourceS3Object;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisItem model) {
            creationTime(model.creationTime);
            enabled(model.enabled);
            ephemerisId(model.ephemerisId);
            name(model.name);
            priority(model.priority);
            sourceS3Object(model.sourceS3Object);
            status(model.status);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEphemerisId() {
            return ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final S3Object.Builder getSourceS3Object() {
            return sourceS3Object != null ? sourceS3Object.toBuilder() : null;
        }

        public final void setSourceS3Object(S3Object.BuilderImpl sourceS3Object) {
            this.sourceS3Object = sourceS3Object != null ? sourceS3Object.build() : null;
        }

        @Override
        public final Builder sourceS3Object(S3Object sourceS3Object) {
            this.sourceS3Object = sourceS3Object;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EphemerisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EphemerisItem build() {
            return new EphemerisItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
