/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigResponse extends GroundStationResponse implements
        ToCopyableBuilder<UpdateConfigResponse.Builder, UpdateConfigResponse> {
    private static final SdkField<String> CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configArn").getter(getter(UpdateConfigResponse::configArn)).setter(setter(Builder::configArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configArn").build()).build();

    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(UpdateConfigResponse::configId)).setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()).build();

    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configType").getter(getter(UpdateConfigResponse::configTypeAsString))
            .setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ARN_FIELD,
            CONFIG_ID_FIELD, CONFIG_TYPE_FIELD));

    private final String configArn;

    private final String configId;

    private final String configType;

    private UpdateConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configArn = builder.configArn;
        this.configId = builder.configId;
        this.configType = builder.configType;
    }

    /**
     * <p>
     * ARN of a <code>Config</code>.
     * </p>
     * 
     * @return ARN of a <code>Config</code>.
     */
    public final String configArn() {
        return configArn;
    }

    /**
     * <p>
     * UUID of a <code>Config</code>.
     * </p>
     * 
     * @return UUID of a <code>Config</code>.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(configType);
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final String configTypeAsString() {
        return configType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configArn());
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(configTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigResponse)) {
            return false;
        }
        UpdateConfigResponse other = (UpdateConfigResponse) obj;
        return Objects.equals(configArn(), other.configArn()) && Objects.equals(configId(), other.configId())
                && Objects.equals(configTypeAsString(), other.configTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigResponse").add("ConfigArn", configArn()).add("ConfigId", configId())
                .add("ConfigType", configTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configArn":
            return Optional.ofNullable(clazz.cast(configArn()));
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "configType":
            return Optional.ofNullable(clazz.cast(configTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigResponse, T> g) {
        return obj -> g.apply((UpdateConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConfigResponse> {
        /**
         * <p>
         * ARN of a <code>Config</code>.
         * </p>
         * 
         * @param configArn
         *        ARN of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configArn(String configArn);

        /**
         * <p>
         * UUID of a <code>Config</code>.
         * </p>
         * 
         * @param configId
         *        UUID of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(String configType);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(ConfigCapabilityType configType);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String configArn;

        private String configId;

        private String configType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigResponse model) {
            super(model);
            configArn(model.configArn);
            configId(model.configId);
            configType(model.configType);
        }

        public final String getConfigArn() {
            return configArn;
        }

        @Override
        public final Builder configArn(String configArn) {
            this.configArn = configArn;
            return this;
        }

        public final void setConfigArn(String configArn) {
            this.configArn = configArn;
        }

        public final String getConfigId() {
            return configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getConfigType() {
            return configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public UpdateConfigResponse build() {
            return new UpdateConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
