/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse;

public class ListDataflowEndpointGroupsPublisher
implements SdkPublisher<ListDataflowEndpointGroupsResponse> {
    private final GroundStationAsyncClient client;
    private final ListDataflowEndpointGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataflowEndpointGroupsPublisher(GroundStationAsyncClient client, ListDataflowEndpointGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataflowEndpointGroupsPublisher(GroundStationAsyncClient client, ListDataflowEndpointGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataflowEndpointGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataflowEndpointGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataflowEndpointListItem> dataflowEndpointGroupList() {
        Function<ListDataflowEndpointGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataflowEndpointGroupList() != null) {
                return response.dataflowEndpointGroupList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataflowEndpointGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataflowEndpointGroupsResponseFetcher
    implements AsyncPageFetcher<ListDataflowEndpointGroupsResponse> {
        private ListDataflowEndpointGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataflowEndpointGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataflowEndpointGroupsResponse> nextPage(ListDataflowEndpointGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDataflowEndpointGroupsPublisher.this.client.listDataflowEndpointGroups(ListDataflowEndpointGroupsPublisher.this.firstRequest);
            }
            return ListDataflowEndpointGroupsPublisher.this.client.listDataflowEndpointGroups((ListDataflowEndpointGroupsRequest)((Object)ListDataflowEndpointGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

