/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.Frequency;
import software.amazon.awssdk.services.groundstation.model.Polarization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UplinkSpectrumConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UplinkSpectrumConfig> {
    private static final SdkField<Frequency> CENTER_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UplinkSpectrumConfig.getter(UplinkSpectrumConfig::centerFrequency)).setter(UplinkSpectrumConfig.setter(Builder::centerFrequency)).constructor(Frequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("centerFrequency").build()}).build();
    private static final SdkField<String> POLARIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UplinkSpectrumConfig.getter(UplinkSpectrumConfig::polarizationAsString)).setter(UplinkSpectrumConfig.setter(Builder::polarization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("polarization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CENTER_FREQUENCY_FIELD, POLARIZATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Frequency centerFrequency;
    private final String polarization;

    private UplinkSpectrumConfig(BuilderImpl builder) {
        this.centerFrequency = builder.centerFrequency;
        this.polarization = builder.polarization;
    }

    public Frequency centerFrequency() {
        return this.centerFrequency;
    }

    public Polarization polarization() {
        return Polarization.fromValue(this.polarization);
    }

    public String polarizationAsString() {
        return this.polarization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.centerFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.polarizationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UplinkSpectrumConfig)) {
            return false;
        }
        UplinkSpectrumConfig other = (UplinkSpectrumConfig)obj;
        return Objects.equals(this.centerFrequency(), other.centerFrequency()) && Objects.equals(this.polarizationAsString(), other.polarizationAsString());
    }

    public String toString() {
        return ToString.builder((String)"UplinkSpectrumConfig").add("CenterFrequency", (Object)this.centerFrequency()).add("Polarization", (Object)this.polarizationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "centerFrequency": {
                return Optional.ofNullable(clazz.cast(this.centerFrequency()));
            }
            case "polarization": {
                return Optional.ofNullable(clazz.cast(this.polarizationAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UplinkSpectrumConfig, T> g) {
        return obj -> g.apply((UplinkSpectrumConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Frequency centerFrequency;
        private String polarization;

        private BuilderImpl() {
        }

        private BuilderImpl(UplinkSpectrumConfig model) {
            this.centerFrequency(model.centerFrequency);
            this.polarization(model.polarization);
        }

        public final Frequency.Builder getCenterFrequency() {
            return this.centerFrequency != null ? this.centerFrequency.toBuilder() : null;
        }

        @Override
        public final Builder centerFrequency(Frequency centerFrequency) {
            this.centerFrequency = centerFrequency;
            return this;
        }

        public final void setCenterFrequency(Frequency.BuilderImpl centerFrequency) {
            this.centerFrequency = centerFrequency != null ? centerFrequency.build() : null;
        }

        public final String getPolarizationAsString() {
            return this.polarization;
        }

        @Override
        public final Builder polarization(String polarization) {
            this.polarization = polarization;
            return this;
        }

        @Override
        public final Builder polarization(Polarization polarization) {
            this.polarization(polarization == null ? null : polarization.toString());
            return this;
        }

        public final void setPolarization(String polarization) {
            this.polarization = polarization;
        }

        public UplinkSpectrumConfig build() {
            return new UplinkSpectrumConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UplinkSpectrumConfig> {
        public Builder centerFrequency(Frequency var1);

        default public Builder centerFrequency(Consumer<Frequency.Builder> centerFrequency) {
            return this.centerFrequency((Frequency)((Frequency.Builder)Frequency.builder().applyMutation(centerFrequency)).build());
        }

        public Builder polarization(String var1);

        public Builder polarization(Polarization var1);
    }
}

