/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSatelliteResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetSatelliteResponse> {
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetSatelliteResponse.getter(GetSatelliteResponse::dateCreated)).setter(GetSatelliteResponse.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetSatelliteResponse.getter(GetSatelliteResponse::lastUpdated)).setter(GetSatelliteResponse.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final SdkField<Integer> NORAD_SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetSatelliteResponse.getter(GetSatelliteResponse::noradSatelliteID)).setter(GetSatelliteResponse.setter(Builder::noradSatelliteID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noradSatelliteID").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSatelliteResponse.getter(GetSatelliteResponse::satelliteArn)).setter(GetSatelliteResponse.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSatelliteResponse.getter(GetSatelliteResponse::satelliteId)).setter(GetSatelliteResponse.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetSatelliteResponse.getter(GetSatelliteResponse::tags)).setter(GetSatelliteResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_CREATED_FIELD, LAST_UPDATED_FIELD, NORAD_SATELLITE_ID_FIELD, SATELLITE_ARN_FIELD, SATELLITE_ID_FIELD, TAGS_FIELD));
    private final Instant dateCreated;
    private final Instant lastUpdated;
    private final Integer noradSatelliteID;
    private final String satelliteArn;
    private final String satelliteId;
    private final Map<String, String> tags;

    private GetSatelliteResponse(BuilderImpl builder) {
        super(builder);
        this.dateCreated = builder.dateCreated;
        this.lastUpdated = builder.lastUpdated;
        this.noradSatelliteID = builder.noradSatelliteID;
        this.satelliteArn = builder.satelliteArn;
        this.satelliteId = builder.satelliteId;
        this.tags = builder.tags;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Integer noradSatelliteID() {
        return this.noradSatelliteID;
    }

    public String satelliteArn() {
        return this.satelliteArn;
    }

    public String satelliteId() {
        return this.satelliteId;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.noradSatelliteID());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSatelliteResponse)) {
            return false;
        }
        GetSatelliteResponse other = (GetSatelliteResponse)((Object)obj);
        return Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.noradSatelliteID(), other.noradSatelliteID()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetSatelliteResponse").add("DateCreated", (Object)this.dateCreated()).add("LastUpdated", (Object)this.lastUpdated()).add("NoradSatelliteID", (Object)this.noradSatelliteID()).add("SatelliteArn", (Object)this.satelliteArn()).add("SatelliteId", (Object)this.satelliteId()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "noradSatelliteID": {
                return Optional.ofNullable(clazz.cast(this.noradSatelliteID()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSatelliteResponse, T> g) {
        return obj -> g.apply((GetSatelliteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private Instant dateCreated;
        private Instant lastUpdated;
        private Integer noradSatelliteID;
        private String satelliteArn;
        private String satelliteId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSatelliteResponse model) {
            super(model);
            this.dateCreated(model.dateCreated);
            this.lastUpdated(model.lastUpdated);
            this.noradSatelliteID(model.noradSatelliteID);
            this.satelliteArn(model.satelliteArn);
            this.satelliteId(model.satelliteId);
            this.tags(model.tags);
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Integer getNoradSatelliteID() {
            return this.noradSatelliteID;
        }

        @Override
        public final Builder noradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
            return this;
        }

        public final void setNoradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public GetSatelliteResponse build() {
            return new GetSatelliteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSatelliteResponse> {
        public Builder dateCreated(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder noradSatelliteID(Integer var1);

        public Builder satelliteArn(String var1);

        public Builder satelliteId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

