/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EndpointDetails;
import software.amazon.awssdk.services.groundstation.model.EndpointDetailsListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataflowEndpointGroupResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetDataflowEndpointGroupResponse> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDataflowEndpointGroupResponse.getter(GetDataflowEndpointGroupResponse::dataflowEndpointGroupArn)).setter(GetDataflowEndpointGroupResponse.setter(Builder::dataflowEndpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupArn").build()}).build();
    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDataflowEndpointGroupResponse.getter(GetDataflowEndpointGroupResponse::dataflowEndpointGroupId)).setter(GetDataflowEndpointGroupResponse.setter(Builder::dataflowEndpointGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupId").build()}).build();
    private static final SdkField<List<EndpointDetails>> ENDPOINTS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDataflowEndpointGroupResponse.getter(GetDataflowEndpointGroupResponse::endpointsDetails)).setter(GetDataflowEndpointGroupResponse.setter(Builder::endpointsDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointsDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetDataflowEndpointGroupResponse.getter(GetDataflowEndpointGroupResponse::tags)).setter(GetDataflowEndpointGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAFLOW_ENDPOINT_GROUP_ARN_FIELD, DATAFLOW_ENDPOINT_GROUP_ID_FIELD, ENDPOINTS_DETAILS_FIELD, TAGS_FIELD));
    private final String dataflowEndpointGroupArn;
    private final String dataflowEndpointGroupId;
    private final List<EndpointDetails> endpointsDetails;
    private final Map<String, String> tags;

    private GetDataflowEndpointGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dataflowEndpointGroupArn = builder.dataflowEndpointGroupArn;
        this.dataflowEndpointGroupId = builder.dataflowEndpointGroupId;
        this.endpointsDetails = builder.endpointsDetails;
        this.tags = builder.tags;
    }

    public String dataflowEndpointGroupArn() {
        return this.dataflowEndpointGroupArn;
    }

    public String dataflowEndpointGroupId() {
        return this.dataflowEndpointGroupId;
    }

    public List<EndpointDetails> endpointsDetails() {
        return this.endpointsDetails;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowEndpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowEndpointGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowEndpointGroupResponse)) {
            return false;
        }
        GetDataflowEndpointGroupResponse other = (GetDataflowEndpointGroupResponse)((Object)obj);
        return Objects.equals(this.dataflowEndpointGroupArn(), other.dataflowEndpointGroupArn()) && Objects.equals(this.dataflowEndpointGroupId(), other.dataflowEndpointGroupId()) && Objects.equals(this.endpointsDetails(), other.endpointsDetails()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetDataflowEndpointGroupResponse").add("DataflowEndpointGroupArn", (Object)this.dataflowEndpointGroupArn()).add("DataflowEndpointGroupId", (Object)this.dataflowEndpointGroupId()).add("EndpointsDetails", this.endpointsDetails()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataflowEndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dataflowEndpointGroupArn()));
            }
            case "dataflowEndpointGroupId": {
                return Optional.ofNullable(clazz.cast(this.dataflowEndpointGroupId()));
            }
            case "endpointsDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointsDetails()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowEndpointGroupResponse, T> g) {
        return obj -> g.apply((GetDataflowEndpointGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String dataflowEndpointGroupArn;
        private String dataflowEndpointGroupId;
        private List<EndpointDetails> endpointsDetails = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowEndpointGroupResponse model) {
            super(model);
            this.dataflowEndpointGroupArn(model.dataflowEndpointGroupArn);
            this.dataflowEndpointGroupId(model.dataflowEndpointGroupId);
            this.endpointsDetails(model.endpointsDetails);
            this.tags(model.tags);
        }

        public final String getDataflowEndpointGroupArn() {
            return this.dataflowEndpointGroupArn;
        }

        @Override
        public final Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
            return this;
        }

        public final void setDataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
        }

        public final String getDataflowEndpointGroupId() {
            return this.dataflowEndpointGroupId;
        }

        @Override
        public final Builder dataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
            return this;
        }

        public final void setDataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
        }

        public final Collection<EndpointDetails.Builder> getEndpointsDetails() {
            return this.endpointsDetails != null ? (Collection)this.endpointsDetails.stream().map(EndpointDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointsDetails(Collection<EndpointDetails> endpointsDetails) {
            this.endpointsDetails = EndpointDetailsListCopier.copy(endpointsDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointsDetails(EndpointDetails ... endpointsDetails) {
            this.endpointsDetails(Arrays.asList(endpointsDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointsDetails(Consumer<EndpointDetails.Builder> ... endpointsDetails) {
            this.endpointsDetails(Stream.of(endpointsDetails).map(c -> (EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointsDetails(Collection<EndpointDetails.BuilderImpl> endpointsDetails) {
            this.endpointsDetails = EndpointDetailsListCopier.copyFromBuilder(endpointsDetails);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public GetDataflowEndpointGroupResponse build() {
            return new GetDataflowEndpointGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataflowEndpointGroupResponse> {
        public Builder dataflowEndpointGroupArn(String var1);

        public Builder dataflowEndpointGroupId(String var1);

        public Builder endpointsDetails(Collection<EndpointDetails> var1);

        public Builder endpointsDetails(EndpointDetails ... var1);

        public Builder endpointsDetails(Consumer<EndpointDetails.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

