/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpoint;
import software.amazon.awssdk.services.groundstation.model.SecurityDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointDetails> {
    private static final SdkField<DataflowEndpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EndpointDetails.getter(EndpointDetails::endpoint)).setter(EndpointDetails.setter(Builder::endpoint)).constructor(DataflowEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<SecurityDetails> SECURITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EndpointDetails.getter(EndpointDetails::securityDetails)).setter(EndpointDetails.setter(Builder::securityDetails)).constructor(SecurityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, SECURITY_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataflowEndpoint endpoint;
    private final SecurityDetails securityDetails;

    private EndpointDetails(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.securityDetails = builder.securityDetails;
    }

    public DataflowEndpoint endpoint() {
        return this.endpoint;
    }

    public SecurityDetails securityDetails() {
        return this.securityDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDetails)) {
            return false;
        }
        EndpointDetails other = (EndpointDetails)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.securityDetails(), other.securityDetails());
    }

    public String toString() {
        return ToString.builder((String)"EndpointDetails").add("Endpoint", (Object)this.endpoint()).add("SecurityDetails", (Object)this.securityDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "securityDetails": {
                return Optional.ofNullable(clazz.cast(this.securityDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointDetails, T> g) {
        return obj -> g.apply((EndpointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataflowEndpoint endpoint;
        private SecurityDetails securityDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDetails model) {
            this.endpoint(model.endpoint);
            this.securityDetails(model.securityDetails);
        }

        public final DataflowEndpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(DataflowEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(DataflowEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final SecurityDetails.Builder getSecurityDetails() {
            return this.securityDetails != null ? this.securityDetails.toBuilder() : null;
        }

        @Override
        public final Builder securityDetails(SecurityDetails securityDetails) {
            this.securityDetails = securityDetails;
            return this;
        }

        public final void setSecurityDetails(SecurityDetails.BuilderImpl securityDetails) {
            this.securityDetails = securityDetails != null ? securityDetails.build() : null;
        }

        public EndpointDetails build() {
            return new EndpointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointDetails> {
        public Builder endpoint(DataflowEndpoint var1);

        default public Builder endpoint(Consumer<DataflowEndpoint.Builder> endpoint) {
            return this.endpoint((DataflowEndpoint)((DataflowEndpoint.Builder)DataflowEndpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder securityDetails(SecurityDetails var1);

        default public Builder securityDetails(Consumer<SecurityDetails.Builder> securityDetails) {
            return this.securityDetails((SecurityDetails)((SecurityDetails.Builder)SecurityDetails.builder().applyMutation(securityDetails)).build());
        }
    }
}

