/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContactStatus {
    AVAILABLE("AVAILABLE"),
    AWS_CANCELLED("AWS_CANCELLED"),
    CANCELLED("CANCELLED"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    FAILED_TO_SCHEDULE("FAILED_TO_SCHEDULE"),
    PASS("PASS"),
    POSTPASS("POSTPASS"),
    PREPASS("PREPASS"),
    SCHEDULED("SCHEDULED"),
    SCHEDULING("SCHEDULING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContactStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContactStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactStatus> knownValues() {
        return Stream.of(ContactStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

