/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.ContactStatus;
import software.amazon.awssdk.services.groundstation.model.Elevation;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactData> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactData.getter(ContactData::contactId)).setter(ContactData.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactId").build()}).build();
    private static final SdkField<String> CONTACT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactData.getter(ContactData::contactStatusAsString)).setter(ContactData.setter(Builder::contactStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactStatus").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContactData.getter(ContactData::endTime)).setter(ContactData.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactData.getter(ContactData::errorMessage)).setter(ContactData.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactData.getter(ContactData::groundStation)).setter(ContactData.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<Elevation> MAXIMUM_ELEVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContactData.getter(ContactData::maximumElevation)).setter(ContactData.setter(Builder::maximumElevation)).constructor(Elevation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumElevation").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactData.getter(ContactData::missionProfileArn)).setter(ContactData.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<Instant> POST_PASS_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContactData.getter(ContactData::postPassEndTime)).setter(ContactData.setter(Builder::postPassEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postPassEndTime").build()}).build();
    private static final SdkField<Instant> PRE_PASS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContactData.getter(ContactData::prePassStartTime)).setter(ContactData.setter(Builder::prePassStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prePassStartTime").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactData.getter(ContactData::satelliteArn)).setter(ContactData.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContactData.getter(ContactData::startTime)).setter(ContactData.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ContactData.getter(ContactData::tags)).setter(ContactData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, CONTACT_STATUS_FIELD, END_TIME_FIELD, ERROR_MESSAGE_FIELD, GROUND_STATION_FIELD, MAXIMUM_ELEVATION_FIELD, MISSION_PROFILE_ARN_FIELD, POST_PASS_END_TIME_FIELD, PRE_PASS_START_TIME_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String contactStatus;
    private final Instant endTime;
    private final String errorMessage;
    private final String groundStation;
    private final Elevation maximumElevation;
    private final String missionProfileArn;
    private final Instant postPassEndTime;
    private final Instant prePassStartTime;
    private final String satelliteArn;
    private final Instant startTime;
    private final Map<String, String> tags;

    private ContactData(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.contactStatus = builder.contactStatus;
        this.endTime = builder.endTime;
        this.errorMessage = builder.errorMessage;
        this.groundStation = builder.groundStation;
        this.maximumElevation = builder.maximumElevation;
        this.missionProfileArn = builder.missionProfileArn;
        this.postPassEndTime = builder.postPassEndTime;
        this.prePassStartTime = builder.prePassStartTime;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
    }

    public String contactId() {
        return this.contactId;
    }

    public ContactStatus contactStatus() {
        return ContactStatus.fromValue(this.contactStatus);
    }

    public String contactStatusAsString() {
        return this.contactStatus;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String groundStation() {
        return this.groundStation;
    }

    public Elevation maximumElevation() {
        return this.maximumElevation;
    }

    public String missionProfileArn() {
        return this.missionProfileArn;
    }

    public Instant postPassEndTime() {
        return this.postPassEndTime;
    }

    public Instant prePassStartTime() {
        return this.prePassStartTime;
    }

    public String satelliteArn() {
        return this.satelliteArn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumElevation());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.postPassEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.prePassStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactData)) {
            return false;
        }
        ContactData other = (ContactData)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.contactStatusAsString(), other.contactStatusAsString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.groundStation(), other.groundStation()) && Objects.equals(this.maximumElevation(), other.maximumElevation()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.postPassEndTime(), other.postPassEndTime()) && Objects.equals(this.prePassStartTime(), other.prePassStartTime()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ContactData").add("ContactId", (Object)this.contactId()).add("ContactStatus", (Object)this.contactStatusAsString()).add("EndTime", (Object)this.endTime()).add("ErrorMessage", (Object)this.errorMessage()).add("GroundStation", (Object)this.groundStation()).add("MaximumElevation", (Object)this.maximumElevation()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("PostPassEndTime", (Object)this.postPassEndTime()).add("PrePassStartTime", (Object)this.prePassStartTime()).add("SatelliteArn", (Object)this.satelliteArn()).add("StartTime", (Object)this.startTime()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "contactStatus": {
                return Optional.ofNullable(clazz.cast(this.contactStatusAsString()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "maximumElevation": {
                return Optional.ofNullable(clazz.cast(this.maximumElevation()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "postPassEndTime": {
                return Optional.ofNullable(clazz.cast(this.postPassEndTime()));
            }
            case "prePassStartTime": {
                return Optional.ofNullable(clazz.cast(this.prePassStartTime()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactData, T> g) {
        return obj -> g.apply((ContactData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String contactStatus;
        private Instant endTime;
        private String errorMessage;
        private String groundStation;
        private Elevation maximumElevation;
        private String missionProfileArn;
        private Instant postPassEndTime;
        private Instant prePassStartTime;
        private String satelliteArn;
        private Instant startTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactData model) {
            this.contactId(model.contactId);
            this.contactStatus(model.contactStatus);
            this.endTime(model.endTime);
            this.errorMessage(model.errorMessage);
            this.groundStation(model.groundStation);
            this.maximumElevation(model.maximumElevation);
            this.missionProfileArn(model.missionProfileArn);
            this.postPassEndTime(model.postPassEndTime);
            this.prePassStartTime(model.prePassStartTime);
            this.satelliteArn(model.satelliteArn);
            this.startTime(model.startTime);
            this.tags(model.tags);
        }

        public final String getContactId() {
            return this.contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        public final String getContactStatusAsString() {
            return this.contactStatus;
        }

        @Override
        public final Builder contactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
            return this;
        }

        @Override
        public final Builder contactStatus(ContactStatus contactStatus) {
            this.contactStatus(contactStatus == null ? null : contactStatus.toString());
            return this;
        }

        public final void setContactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        public final Elevation.Builder getMaximumElevation() {
            return this.maximumElevation != null ? this.maximumElevation.toBuilder() : null;
        }

        @Override
        public final Builder maximumElevation(Elevation maximumElevation) {
            this.maximumElevation = maximumElevation;
            return this;
        }

        public final void setMaximumElevation(Elevation.BuilderImpl maximumElevation) {
            this.maximumElevation = maximumElevation != null ? maximumElevation.build() : null;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        public final Instant getPostPassEndTime() {
            return this.postPassEndTime;
        }

        @Override
        public final Builder postPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
            return this;
        }

        public final void setPostPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
        }

        public final Instant getPrePassStartTime() {
            return this.prePassStartTime;
        }

        @Override
        public final Builder prePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
            return this;
        }

        public final void setPrePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public ContactData build() {
            return new ContactData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactData> {
        public Builder contactId(String var1);

        public Builder contactStatus(String var1);

        public Builder contactStatus(ContactStatus var1);

        public Builder endTime(Instant var1);

        public Builder errorMessage(String var1);

        public Builder groundStation(String var1);

        public Builder maximumElevation(Elevation var1);

        default public Builder maximumElevation(Consumer<Elevation.Builder> maximumElevation) {
            return this.maximumElevation((Elevation)((Elevation.Builder)Elevation.builder().applyMutation(maximumElevation)).build());
        }

        public Builder missionProfileArn(String var1);

        public Builder postPassEndTime(Instant var1);

        public Builder prePassStartTime(Instant var1);

        public Builder satelliteArn(String var1);

        public Builder startTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

