/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.Eirp;
import software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AntennaUplinkConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AntennaUplinkConfig> {
    private static final SdkField<UplinkSpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AntennaUplinkConfig.getter(AntennaUplinkConfig::spectrumConfig)).setter(AntennaUplinkConfig.setter(Builder::spectrumConfig)).constructor(UplinkSpectrumConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()}).build();
    private static final SdkField<Eirp> TARGET_EIRP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AntennaUplinkConfig.getter(AntennaUplinkConfig::targetEirp)).setter(AntennaUplinkConfig.setter(Builder::targetEirp)).constructor(Eirp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetEirp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECTRUM_CONFIG_FIELD, TARGET_EIRP_FIELD));
    private static final long serialVersionUID = 1L;
    private final UplinkSpectrumConfig spectrumConfig;
    private final Eirp targetEirp;

    private AntennaUplinkConfig(BuilderImpl builder) {
        this.spectrumConfig = builder.spectrumConfig;
        this.targetEirp = builder.targetEirp;
    }

    public UplinkSpectrumConfig spectrumConfig() {
        return this.spectrumConfig;
    }

    public Eirp targetEirp() {
        return this.targetEirp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spectrumConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEirp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaUplinkConfig)) {
            return false;
        }
        AntennaUplinkConfig other = (AntennaUplinkConfig)obj;
        return Objects.equals(this.spectrumConfig(), other.spectrumConfig()) && Objects.equals(this.targetEirp(), other.targetEirp());
    }

    public String toString() {
        return ToString.builder((String)"AntennaUplinkConfig").add("SpectrumConfig", (Object)this.spectrumConfig()).add("TargetEirp", (Object)this.targetEirp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spectrumConfig": {
                return Optional.ofNullable(clazz.cast(this.spectrumConfig()));
            }
            case "targetEirp": {
                return Optional.ofNullable(clazz.cast(this.targetEirp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntennaUplinkConfig, T> g) {
        return obj -> g.apply((AntennaUplinkConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UplinkSpectrumConfig spectrumConfig;
        private Eirp targetEirp;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaUplinkConfig model) {
            this.spectrumConfig(model.spectrumConfig);
            this.targetEirp(model.targetEirp);
        }

        public final UplinkSpectrumConfig.Builder getSpectrumConfig() {
            return this.spectrumConfig != null ? this.spectrumConfig.toBuilder() : null;
        }

        @Override
        public final Builder spectrumConfig(UplinkSpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        public final void setSpectrumConfig(UplinkSpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        public final Eirp.Builder getTargetEirp() {
            return this.targetEirp != null ? this.targetEirp.toBuilder() : null;
        }

        @Override
        public final Builder targetEirp(Eirp targetEirp) {
            this.targetEirp = targetEirp;
            return this;
        }

        public final void setTargetEirp(Eirp.BuilderImpl targetEirp) {
            this.targetEirp = targetEirp != null ? targetEirp.build() : null;
        }

        public AntennaUplinkConfig build() {
            return new AntennaUplinkConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AntennaUplinkConfig> {
        public Builder spectrumConfig(UplinkSpectrumConfig var1);

        default public Builder spectrumConfig(Consumer<UplinkSpectrumConfig.Builder> spectrumConfig) {
            return this.spectrumConfig((UplinkSpectrumConfig)((UplinkSpectrumConfig.Builder)UplinkSpectrumConfig.builder().applyMutation(spectrumConfig)).build());
        }

        public Builder targetEirp(Eirp var1);

        default public Builder targetEirp(Consumer<Eirp.Builder> targetEirp) {
            return this.targetEirp((Eirp)((Eirp.Builder)Eirp.builder().applyMutation(targetEirp)).build());
        }
    }
}

