/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateAction {
    ADD("ADD"),
    REVOKE("REVOKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateAction> VALUE_MAP;
    private final String value;

    private UpdateAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateAction> knownValues() {
        EnumSet<UpdateAction> knownValues = EnumSet.allOf(UpdateAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateAction.class, UpdateAction::toString);
    }
}

