/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.Role;
import software.amazon.awssdk.services.grafana.model.UpdateAction;
import software.amazon.awssdk.services.grafana.model.User;
import software.amazon.awssdk.services.grafana.model.UserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInstruction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateInstruction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(UpdateInstruction.getter(UpdateInstruction::actionAsString)).setter(UpdateInstruction.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(UpdateInstruction.getter(UpdateInstruction::roleAsString)).setter(UpdateInstruction.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<List<User>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("users").getter(UpdateInstruction.getter(UpdateInstruction::users)).setter(UpdateInstruction.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ROLE_FIELD, USERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("action", ACTION_FIELD);
            this.put("role", ROLE_FIELD);
            this.put("users", USERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String role;
    private final List<User> users;

    private UpdateInstruction(BuilderImpl builder) {
        this.action = builder.action;
        this.role = builder.role;
        this.users = builder.users;
    }

    public final UpdateAction action() {
        return UpdateAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Role role() {
        return Role.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<User> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstruction)) {
            return false;
        }
        UpdateInstruction other = (UpdateInstruction)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.roleAsString(), other.roleAsString()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInstruction").add("Action", (Object)this.actionAsString()).add("Role", (Object)this.roleAsString()).add("Users", this.hasUsers() ? this.users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstruction, T> g) {
        return obj -> g.apply((UpdateInstruction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String role;
        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstruction model) {
            this.action(model.action);
            this.role(model.role);
            this.users(model.users);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final List<User.Builder> getUsers() {
            List<User.Builder> result = UserListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = UserListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = UserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (User)((User.Builder)User.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UpdateInstruction build() {
            return new UpdateInstruction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateInstruction> {
        public Builder action(String var1);

        public Builder action(UpdateAction var1);

        public Builder role(String var1);

        public Builder role(Role var1);

        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder users(Consumer<User.Builder> ... var1);
    }
}

