/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the information about a service account token.
 * </p>
 * <p>
 * This structure is returned when creating the token. It is important to store the <code>key</code> that is returned,
 * as it is not retrievable at a later time.
 * </p>
 * <p>
 * If you lose the key, you can delete and recreate the token, which will create a new key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceAccountTokenSummaryWithKey implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceAccountTokenSummaryWithKey.Builder, ServiceAccountTokenSummaryWithKey> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServiceAccountTokenSummaryWithKey::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(ServiceAccountTokenSummaryWithKey::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceAccountTokenSummaryWithKey::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, KEY_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String key;

    private final String name;

    private ServiceAccountTokenSummaryWithKey(BuilderImpl builder) {
        this.id = builder.id;
        this.key = builder.key;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique ID of the service account token.
     * </p>
     * 
     * @return The unique ID of the service account token.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and
     * authorize the requests.
     * </p>
     * 
     * @return The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate
     *         and authorize the requests.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The name of the service account token.
     * </p>
     * 
     * @return The name of the service account token.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountTokenSummaryWithKey)) {
            return false;
        }
        ServiceAccountTokenSummaryWithKey other = (ServiceAccountTokenSummaryWithKey) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(key(), other.key()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceAccountTokenSummaryWithKey").add("Id", id())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceAccountTokenSummaryWithKey, T> g) {
        return obj -> g.apply((ServiceAccountTokenSummaryWithKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceAccountTokenSummaryWithKey> {
        /**
         * <p>
         * The unique ID of the service account token.
         * </p>
         * 
         * @param id
         *        The unique ID of the service account token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and
         * authorize the requests.
         * </p>
         * 
         * @param key
         *        The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate
         *        and authorize the requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the service account token.
         * </p>
         * 
         * @param name
         *        The name of the service account token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String key;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountTokenSummaryWithKey model) {
            id(model.id);
            key(model.key);
            name(model.name);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ServiceAccountTokenSummaryWithKey build() {
            return new ServiceAccountTokenSummaryWithKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
