/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the information about one service account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceAccountSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceAccountSummary.Builder, ServiceAccountSummary> {
    private static final SdkField<String> GRAFANA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("grafanaRole").getter(getter(ServiceAccountSummary::grafanaRoleAsString))
            .setter(setter(Builder::grafanaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaRole").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServiceAccountSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> IS_DISABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("isDisabled").getter(getter(ServiceAccountSummary::isDisabled)).setter(setter(Builder::isDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDisabled").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceAccountSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAFANA_ROLE_FIELD, ID_FIELD,
            IS_DISABLED_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String grafanaRole;

    private final String id;

    private final String isDisabled;

    private final String name;

    private ServiceAccountSummary(BuilderImpl builder) {
        this.grafanaRole = builder.grafanaRole;
        this.id = builder.id;
        this.isDisabled = builder.isDisabled;
        this.name = builder.name;
    }

    /**
     * <p>
     * The role of the service account, which sets the permission level used when calling Grafana APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grafanaRole} will
     * return {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grafanaRoleAsString}.
     * </p>
     * 
     * @return The role of the service account, which sets the permission level used when calling Grafana APIs.
     * @see Role
     */
    public final Role grafanaRole() {
        return Role.fromValue(grafanaRole);
    }

    /**
     * <p>
     * The role of the service account, which sets the permission level used when calling Grafana APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grafanaRole} will
     * return {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grafanaRoleAsString}.
     * </p>
     * 
     * @return The role of the service account, which sets the permission level used when calling Grafana APIs.
     * @see Role
     */
    public final String grafanaRoleAsString() {
        return grafanaRole;
    }

    /**
     * <p>
     * The unique ID of the service account.
     * </p>
     * 
     * @return The unique ID of the service account.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Returns true if the service account is disabled. Service accounts can be disabled and enabled in the Amazon
     * Managed Grafana console.
     * </p>
     * 
     * @return Returns true if the service account is disabled. Service accounts can be disabled and enabled in the
     *         Amazon Managed Grafana console.
     */
    public final String isDisabled() {
        return isDisabled;
    }

    /**
     * <p>
     * The name of the service account.
     * </p>
     * 
     * @return The name of the service account.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grafanaRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountSummary)) {
            return false;
        }
        ServiceAccountSummary other = (ServiceAccountSummary) obj;
        return Objects.equals(grafanaRoleAsString(), other.grafanaRoleAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(isDisabled(), other.isDisabled()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceAccountSummary").add("GrafanaRole", grafanaRoleAsString()).add("Id", id())
                .add("IsDisabled", isDisabled()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grafanaRole":
            return Optional.ofNullable(clazz.cast(grafanaRoleAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "isDisabled":
            return Optional.ofNullable(clazz.cast(isDisabled()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceAccountSummary, T> g) {
        return obj -> g.apply((ServiceAccountSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceAccountSummary> {
        /**
         * <p>
         * The role of the service account, which sets the permission level used when calling Grafana APIs.
         * </p>
         * 
         * @param grafanaRole
         *        The role of the service account, which sets the permission level used when calling Grafana APIs.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder grafanaRole(String grafanaRole);

        /**
         * <p>
         * The role of the service account, which sets the permission level used when calling Grafana APIs.
         * </p>
         * 
         * @param grafanaRole
         *        The role of the service account, which sets the permission level used when calling Grafana APIs.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder grafanaRole(Role grafanaRole);

        /**
         * <p>
         * The unique ID of the service account.
         * </p>
         * 
         * @param id
         *        The unique ID of the service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Returns true if the service account is disabled. Service accounts can be disabled and enabled in the Amazon
         * Managed Grafana console.
         * </p>
         * 
         * @param isDisabled
         *        Returns true if the service account is disabled. Service accounts can be disabled and enabled in the
         *        Amazon Managed Grafana console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDisabled(String isDisabled);

        /**
         * <p>
         * The name of the service account.
         * </p>
         * 
         * @param name
         *        The name of the service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String grafanaRole;

        private String id;

        private String isDisabled;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountSummary model) {
            grafanaRole(model.grafanaRole);
            id(model.id);
            isDisabled(model.isDisabled);
            name(model.name);
        }

        public final String getGrafanaRole() {
            return grafanaRole;
        }

        public final void setGrafanaRole(String grafanaRole) {
            this.grafanaRole = grafanaRole;
        }

        @Override
        public final Builder grafanaRole(String grafanaRole) {
            this.grafanaRole = grafanaRole;
            return this;
        }

        @Override
        public final Builder grafanaRole(Role grafanaRole) {
            this.grafanaRole(grafanaRole == null ? null : grafanaRole.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIsDisabled() {
            return isDisabled;
        }

        public final void setIsDisabled(String isDisabled) {
            this.isDisabled = isDisabled;
        }

        @Override
        public final Builder isDisabled(String isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ServiceAccountSummary build() {
            return new ServiceAccountSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
