/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about how this workspace works with SAML.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SamlConfiguration.Builder, SamlConfiguration> {
    private static final SdkField<List<String>> ALLOWED_ORGANIZATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedOrganizations")
            .getter(getter(SamlConfiguration::allowedOrganizations))
            .setter(setter(Builder::allowedOrganizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedOrganizations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AssertionAttributes> ASSERTION_ATTRIBUTES_FIELD = SdkField
            .<AssertionAttributes> builder(MarshallingType.SDK_POJO).memberName("assertionAttributes")
            .getter(getter(SamlConfiguration::assertionAttributes)).setter(setter(Builder::assertionAttributes))
            .constructor(AssertionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assertionAttributes").build())
            .build();

    private static final SdkField<IdpMetadata> IDP_METADATA_FIELD = SdkField.<IdpMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("idpMetadata").getter(getter(SamlConfiguration::idpMetadata)).setter(setter(Builder::idpMetadata))
            .constructor(IdpMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idpMetadata").build()).build();

    private static final SdkField<Integer> LOGIN_VALIDITY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("loginValidityDuration").getter(getter(SamlConfiguration::loginValidityDuration))
            .setter(setter(Builder::loginValidityDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loginValidityDuration").build())
            .build();

    private static final SdkField<RoleValues> ROLE_VALUES_FIELD = SdkField.<RoleValues> builder(MarshallingType.SDK_POJO)
            .memberName("roleValues").getter(getter(SamlConfiguration::roleValues)).setter(setter(Builder::roleValues))
            .constructor(RoleValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ORGANIZATIONS_FIELD,
            ASSERTION_ATTRIBUTES_FIELD, IDP_METADATA_FIELD, LOGIN_VALIDITY_DURATION_FIELD, ROLE_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> allowedOrganizations;

    private final AssertionAttributes assertionAttributes;

    private final IdpMetadata idpMetadata;

    private final Integer loginValidityDuration;

    private final RoleValues roleValues;

    private SamlConfiguration(BuilderImpl builder) {
        this.allowedOrganizations = builder.allowedOrganizations;
        this.assertionAttributes = builder.assertionAttributes;
        this.idpMetadata = builder.idpMetadata;
        this.loginValidityDuration = builder.loginValidityDuration;
        this.roleValues = builder.roleValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedOrganizations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedOrganizations() {
        return allowedOrganizations != null && !(allowedOrganizations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace.
     * If this is empty, all organizations in the assertion attribute have access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOrganizations} method.
     * </p>
     * 
     * @return Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana
     *         workspace. If this is empty, all organizations in the assertion attribute have access.
     */
    public final List<String> allowedOrganizations() {
        return allowedOrganizations;
    }

    /**
     * <p>
     * A structure that defines which attributes in the SAML assertion are to be used to define information about the
     * users authenticated by that IdP to use the workspace.
     * </p>
     * 
     * @return A structure that defines which attributes in the SAML assertion are to be used to define information
     *         about the users authenticated by that IdP to use the workspace.
     */
    public final AssertionAttributes assertionAttributes() {
        return assertionAttributes;
    }

    /**
     * <p>
     * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this
     * workspace.
     * </p>
     * 
     * @return A structure containing the identity provider (IdP) metadata used to integrate the identity provider with
     *         this workspace.
     */
    public final IdpMetadata idpMetadata() {
        return idpMetadata;
    }

    /**
     * <p>
     * How long a sign-on session by a SAML user is valid, before the user has to sign on again.
     * </p>
     * 
     * @return How long a sign-on session by a SAML user is valid, before the user has to sign on again.
     */
    public final Integer loginValidityDuration() {
        return loginValidityDuration;
    }

    /**
     * <p>
     * A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and
     * <code>Editor</code> roles in the workspace.
     * </p>
     * 
     * @return A structure containing arrays that map group names in the SAML assertion to the Grafana
     *         <code>Admin</code> and <code>Editor</code> roles in the workspace.
     */
    public final RoleValues roleValues() {
        return roleValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOrganizations() ? allowedOrganizations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assertionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(idpMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(loginValidityDuration());
        hashCode = 31 * hashCode + Objects.hashCode(roleValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlConfiguration)) {
            return false;
        }
        SamlConfiguration other = (SamlConfiguration) obj;
        return hasAllowedOrganizations() == other.hasAllowedOrganizations()
                && Objects.equals(allowedOrganizations(), other.allowedOrganizations())
                && Objects.equals(assertionAttributes(), other.assertionAttributes())
                && Objects.equals(idpMetadata(), other.idpMetadata())
                && Objects.equals(loginValidityDuration(), other.loginValidityDuration())
                && Objects.equals(roleValues(), other.roleValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamlConfiguration")
                .add("AllowedOrganizations", hasAllowedOrganizations() ? allowedOrganizations() : null)
                .add("AssertionAttributes", assertionAttributes()).add("IdpMetadata", idpMetadata())
                .add("LoginValidityDuration", loginValidityDuration()).add("RoleValues", roleValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedOrganizations":
            return Optional.ofNullable(clazz.cast(allowedOrganizations()));
        case "assertionAttributes":
            return Optional.ofNullable(clazz.cast(assertionAttributes()));
        case "idpMetadata":
            return Optional.ofNullable(clazz.cast(idpMetadata()));
        case "loginValidityDuration":
            return Optional.ofNullable(clazz.cast(loginValidityDuration()));
        case "roleValues":
            return Optional.ofNullable(clazz.cast(roleValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamlConfiguration, T> g) {
        return obj -> g.apply((SamlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamlConfiguration> {
        /**
         * <p>
         * Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana
         * workspace. If this is empty, all organizations in the assertion attribute have access.
         * </p>
         * 
         * @param allowedOrganizations
         *        Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana
         *        workspace. If this is empty, all organizations in the assertion attribute have access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrganizations(Collection<String> allowedOrganizations);

        /**
         * <p>
         * Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana
         * workspace. If this is empty, all organizations in the assertion attribute have access.
         * </p>
         * 
         * @param allowedOrganizations
         *        Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana
         *        workspace. If this is empty, all organizations in the assertion attribute have access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrganizations(String... allowedOrganizations);

        /**
         * <p>
         * A structure that defines which attributes in the SAML assertion are to be used to define information about
         * the users authenticated by that IdP to use the workspace.
         * </p>
         * 
         * @param assertionAttributes
         *        A structure that defines which attributes in the SAML assertion are to be used to define information
         *        about the users authenticated by that IdP to use the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertionAttributes(AssertionAttributes assertionAttributes);

        /**
         * <p>
         * A structure that defines which attributes in the SAML assertion are to be used to define information about
         * the users authenticated by that IdP to use the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssertionAttributes.Builder} avoiding the
         * need to create one manually via {@link AssertionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssertionAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #assertionAttributes(AssertionAttributes)}.
         * 
         * @param assertionAttributes
         *        a consumer that will call methods on {@link AssertionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assertionAttributes(AssertionAttributes)
         */
        default Builder assertionAttributes(Consumer<AssertionAttributes.Builder> assertionAttributes) {
            return assertionAttributes(AssertionAttributes.builder().applyMutation(assertionAttributes).build());
        }

        /**
         * <p>
         * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this
         * workspace.
         * </p>
         * 
         * @param idpMetadata
         *        A structure containing the identity provider (IdP) metadata used to integrate the identity provider
         *        with this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpMetadata(IdpMetadata idpMetadata);

        /**
         * <p>
         * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this
         * workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdpMetadata.Builder} avoiding the need to
         * create one manually via {@link IdpMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdpMetadata.Builder#build()} is called immediately and its result
         * is passed to {@link #idpMetadata(IdpMetadata)}.
         * 
         * @param idpMetadata
         *        a consumer that will call methods on {@link IdpMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idpMetadata(IdpMetadata)
         */
        default Builder idpMetadata(Consumer<IdpMetadata.Builder> idpMetadata) {
            return idpMetadata(IdpMetadata.builder().applyMutation(idpMetadata).build());
        }

        /**
         * <p>
         * How long a sign-on session by a SAML user is valid, before the user has to sign on again.
         * </p>
         * 
         * @param loginValidityDuration
         *        How long a sign-on session by a SAML user is valid, before the user has to sign on again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginValidityDuration(Integer loginValidityDuration);

        /**
         * <p>
         * A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code>
         * and <code>Editor</code> roles in the workspace.
         * </p>
         * 
         * @param roleValues
         *        A structure containing arrays that map group names in the SAML assertion to the Grafana
         *        <code>Admin</code> and <code>Editor</code> roles in the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleValues(RoleValues roleValues);

        /**
         * <p>
         * A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code>
         * and <code>Editor</code> roles in the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoleValues.Builder} avoiding the need to
         * create one manually via {@link RoleValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoleValues.Builder#build()} is called immediately and its result
         * is passed to {@link #roleValues(RoleValues)}.
         * 
         * @param roleValues
         *        a consumer that will call methods on {@link RoleValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleValues(RoleValues)
         */
        default Builder roleValues(Consumer<RoleValues.Builder> roleValues) {
            return roleValues(RoleValues.builder().applyMutation(roleValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedOrganizations = DefaultSdkAutoConstructList.getInstance();

        private AssertionAttributes assertionAttributes;

        private IdpMetadata idpMetadata;

        private Integer loginValidityDuration;

        private RoleValues roleValues;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlConfiguration model) {
            allowedOrganizations(model.allowedOrganizations);
            assertionAttributes(model.assertionAttributes);
            idpMetadata(model.idpMetadata);
            loginValidityDuration(model.loginValidityDuration);
            roleValues(model.roleValues);
        }

        public final Collection<String> getAllowedOrganizations() {
            if (allowedOrganizations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOrganizations;
        }

        public final void setAllowedOrganizations(Collection<String> allowedOrganizations) {
            this.allowedOrganizations = AllowedOrganizationsCopier.copy(allowedOrganizations);
        }

        @Override
        public final Builder allowedOrganizations(Collection<String> allowedOrganizations) {
            this.allowedOrganizations = AllowedOrganizationsCopier.copy(allowedOrganizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrganizations(String... allowedOrganizations) {
            allowedOrganizations(Arrays.asList(allowedOrganizations));
            return this;
        }

        public final AssertionAttributes.Builder getAssertionAttributes() {
            return assertionAttributes != null ? assertionAttributes.toBuilder() : null;
        }

        public final void setAssertionAttributes(AssertionAttributes.BuilderImpl assertionAttributes) {
            this.assertionAttributes = assertionAttributes != null ? assertionAttributes.build() : null;
        }

        @Override
        public final Builder assertionAttributes(AssertionAttributes assertionAttributes) {
            this.assertionAttributes = assertionAttributes;
            return this;
        }

        public final IdpMetadata.Builder getIdpMetadata() {
            return idpMetadata != null ? idpMetadata.toBuilder() : null;
        }

        public final void setIdpMetadata(IdpMetadata.BuilderImpl idpMetadata) {
            this.idpMetadata = idpMetadata != null ? idpMetadata.build() : null;
        }

        @Override
        public final Builder idpMetadata(IdpMetadata idpMetadata) {
            this.idpMetadata = idpMetadata;
            return this;
        }

        public final Integer getLoginValidityDuration() {
            return loginValidityDuration;
        }

        public final void setLoginValidityDuration(Integer loginValidityDuration) {
            this.loginValidityDuration = loginValidityDuration;
        }

        @Override
        public final Builder loginValidityDuration(Integer loginValidityDuration) {
            this.loginValidityDuration = loginValidityDuration;
            return this;
        }

        public final RoleValues.Builder getRoleValues() {
            return roleValues != null ? roleValues.toBuilder() : null;
        }

        public final void setRoleValues(RoleValues.BuilderImpl roleValues) {
            this.roleValues = roleValues != null ? roleValues.build() : null;
        }

        @Override
        public final Builder roleValues(RoleValues roleValues) {
            this.roleValues = roleValues;
            return this;
        }

        @Override
        public SamlConfiguration build() {
            return new SamlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
