/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;

public class SearchTablesPublisher
implements SdkPublisher<SearchTablesResponse> {
    private final GlueAsyncClient client;
    private final SearchTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchTablesPublisher(GlueAsyncClient client, SearchTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchTablesPublisher(GlueAsyncClient client, SearchTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchTablesResponseFetcher
    implements AsyncPageFetcher<SearchTablesResponse> {
        private SearchTablesResponseFetcher() {
        }

        public boolean hasNextPage(SearchTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchTablesResponse> nextPage(SearchTablesResponse previousPage) {
            if (previousPage == null) {
                return SearchTablesPublisher.this.client.searchTables(SearchTablesPublisher.this.firstRequest);
            }
            return SearchTablesPublisher.this.client.searchTables((SearchTablesRequest)((Object)SearchTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

