/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnError> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ColumnError.getter(ColumnError::columnName)).setter(ColumnError.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ColumnError.getter(ColumnError::error)).setter(ColumnError.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final ErrorDetail error;

    private ColumnError(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.error = builder.error;
    }

    public String columnName() {
        return this.columnName;
    }

    public ErrorDetail error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnError)) {
            return false;
        }
        ColumnError other = (ColumnError)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.error(), other.error());
    }

    public String toString() {
        return ToString.builder((String)"ColumnError").add("ColumnName", (Object)this.columnName()).add("Error", (Object)this.error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnError, T> g) {
        return obj -> g.apply((ColumnError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnError model) {
            this.columnName(model.columnName);
            this.error(model.error);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public ColumnError build() {
            return new ColumnError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnError> {
        public Builder columnName(String var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }
    }
}

