/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TableError;
import software.amazon.awssdk.services.glue.model.TableErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteTableResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchDeleteTableResponse> {
    private static final SdkField<List<TableError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteTableResponse.getter(BatchDeleteTableResponse::errors)).setter(BatchDeleteTableResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));
    private final List<TableError> errors;

    private BatchDeleteTableResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<TableError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTableResponse)) {
            return false;
        }
        BatchDeleteTableResponse other = (BatchDeleteTableResponse)((Object)obj);
        return Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteTableResponse").add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTableResponse, T> g) {
        return obj -> g.apply((BatchDeleteTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<TableError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTableResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final Collection<TableError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(TableError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<TableError> errors) {
            this.errors = TableErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(TableError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<TableError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (TableError)((TableError.Builder)TableError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<TableError.BuilderImpl> errors) {
            this.errors = TableErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeleteTableResponse build() {
            return new BatchDeleteTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteTableResponse> {
        public Builder errors(Collection<TableError> var1);

        public Builder errors(TableError ... var1);

        public Builder errors(Consumer<TableError.Builder> ... var1);
    }
}

