/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScaleBarUnit {
    KILOMETERS("Kilometers"),
    KILOMETERS_MILES("KilometersMiles"),
    MILES("Miles"),
    MILES_KILOMETERS("MilesKilometers"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScaleBarUnit> VALUE_MAP;
    private final String value;

    private ScaleBarUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScaleBarUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScaleBarUnit> knownValues() {
        EnumSet<ScaleBarUnit> knownValues = EnumSet.allOf(ScaleBarUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScaleBarUnit.class, ScaleBarUnit::toString);
    }
}

