/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MapStyle {
    STANDARD("Standard"),
    MONOCHROME("Monochrome"),
    HYBRID("Hybrid"),
    SATELLITE("Satellite"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MapStyle> VALUE_MAP;
    private final String value;

    private MapStyle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MapStyle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MapStyle> knownValues() {
        EnumSet<MapStyle> knownValues = EnumSet.allOf(MapStyle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MapStyle.class, MapStyle::toString);
    }
}

