/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionStatus;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupType;
import software.amazon.awssdk.services.gamelift.model.ContainerOperatingSystem;
import software.amazon.awssdk.services.gamelift.model.GameServerContainerDefinition;
import software.amazon.awssdk.services.gamelift.model.SupportContainerDefinition;
import software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerGroupDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerGroupDefinition> {
    private static final SdkField<String> CONTAINER_GROUP_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerGroupDefinitionArn").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::containerGroupDefinitionArn)).setter(ContainerGroupDefinition.setter(Builder::containerGroupDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::creationTime)).setter(ContainerGroupDefinition.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::operatingSystemAsString)).setter(ContainerGroupDefinition.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::name)).setter(ContainerGroupDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONTAINER_GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerGroupType").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::containerGroupTypeAsString)).setter(ContainerGroupDefinition.setter(Builder::containerGroupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupType").build()}).build();
    private static final SdkField<Integer> TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalMemoryLimitMebibytes").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::totalMemoryLimitMebibytes)).setter(ContainerGroupDefinition.setter(Builder::totalMemoryLimitMebibytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMemoryLimitMebibytes").build()}).build();
    private static final SdkField<Double> TOTAL_VCPU_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalVcpuLimit").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::totalVcpuLimit)).setter(ContainerGroupDefinition.setter(Builder::totalVcpuLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalVcpuLimit").build()}).build();
    private static final SdkField<GameServerContainerDefinition> GAME_SERVER_CONTAINER_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GameServerContainerDefinition").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::gameServerContainerDefinition)).setter(ContainerGroupDefinition.setter(Builder::gameServerContainerDefinition)).constructor(GameServerContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerDefinition").build()}).build();
    private static final SdkField<List<SupportContainerDefinition>> SUPPORT_CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportContainerDefinitions").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::supportContainerDefinitions)).setter(ContainerGroupDefinition.setter(Builder::supportContainerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportContainerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VersionNumber").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::versionNumber)).setter(ContainerGroupDefinition.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::versionDescription)).setter(ContainerGroupDefinition.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::statusAsString)).setter(ContainerGroupDefinition.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::statusReason)).setter(ContainerGroupDefinition.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_GROUP_DEFINITION_ARN_FIELD, CREATION_TIME_FIELD, OPERATING_SYSTEM_FIELD, NAME_FIELD, CONTAINER_GROUP_TYPE_FIELD, TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD, TOTAL_VCPU_LIMIT_FIELD, GAME_SERVER_CONTAINER_DEFINITION_FIELD, SUPPORT_CONTAINER_DEFINITIONS_FIELD, VERSION_NUMBER_FIELD, VERSION_DESCRIPTION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerGroupDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerGroupDefinitionArn;
    private final Instant creationTime;
    private final String operatingSystem;
    private final String name;
    private final String containerGroupType;
    private final Integer totalMemoryLimitMebibytes;
    private final Double totalVcpuLimit;
    private final GameServerContainerDefinition gameServerContainerDefinition;
    private final List<SupportContainerDefinition> supportContainerDefinitions;
    private final Integer versionNumber;
    private final String versionDescription;
    private final String status;
    private final String statusReason;

    private ContainerGroupDefinition(BuilderImpl builder) {
        this.containerGroupDefinitionArn = builder.containerGroupDefinitionArn;
        this.creationTime = builder.creationTime;
        this.operatingSystem = builder.operatingSystem;
        this.name = builder.name;
        this.containerGroupType = builder.containerGroupType;
        this.totalMemoryLimitMebibytes = builder.totalMemoryLimitMebibytes;
        this.totalVcpuLimit = builder.totalVcpuLimit;
        this.gameServerContainerDefinition = builder.gameServerContainerDefinition;
        this.supportContainerDefinitions = builder.supportContainerDefinitions;
        this.versionNumber = builder.versionNumber;
        this.versionDescription = builder.versionDescription;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String containerGroupDefinitionArn() {
        return this.containerGroupDefinitionArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ContainerOperatingSystem operatingSystem() {
        return ContainerOperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerGroupType containerGroupType() {
        return ContainerGroupType.fromValue(this.containerGroupType);
    }

    public final String containerGroupTypeAsString() {
        return this.containerGroupType;
    }

    public final Integer totalMemoryLimitMebibytes() {
        return this.totalMemoryLimitMebibytes;
    }

    public final Double totalVcpuLimit() {
        return this.totalVcpuLimit;
    }

    public final GameServerContainerDefinition gameServerContainerDefinition() {
        return this.gameServerContainerDefinition;
    }

    public final boolean hasSupportContainerDefinitions() {
        return this.supportContainerDefinitions != null && !(this.supportContainerDefinitions instanceof SdkAutoConstructList);
    }

    public final List<SupportContainerDefinition> supportContainerDefinitions() {
        return this.supportContainerDefinitions;
    }

    public final Integer versionNumber() {
        return this.versionNumber;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final ContainerGroupDefinitionStatus status() {
        return ContainerGroupDefinitionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerGroupDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerGroupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMemoryLimitMebibytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalVcpuLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportContainerDefinitions() ? this.supportContainerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupDefinition)) {
            return false;
        }
        ContainerGroupDefinition other = (ContainerGroupDefinition)obj;
        return Objects.equals(this.containerGroupDefinitionArn(), other.containerGroupDefinitionArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.containerGroupTypeAsString(), other.containerGroupTypeAsString()) && Objects.equals(this.totalMemoryLimitMebibytes(), other.totalMemoryLimitMebibytes()) && Objects.equals(this.totalVcpuLimit(), other.totalVcpuLimit()) && Objects.equals(this.gameServerContainerDefinition(), other.gameServerContainerDefinition()) && this.hasSupportContainerDefinitions() == other.hasSupportContainerDefinitions() && Objects.equals(this.supportContainerDefinitions(), other.supportContainerDefinitions()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerGroupDefinition").add("ContainerGroupDefinitionArn", (Object)this.containerGroupDefinitionArn()).add("CreationTime", (Object)this.creationTime()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("Name", (Object)this.name()).add("ContainerGroupType", (Object)this.containerGroupTypeAsString()).add("TotalMemoryLimitMebibytes", (Object)this.totalMemoryLimitMebibytes()).add("TotalVcpuLimit", (Object)this.totalVcpuLimit()).add("GameServerContainerDefinition", (Object)this.gameServerContainerDefinition()).add("SupportContainerDefinitions", this.hasSupportContainerDefinitions() ? this.supportContainerDefinitions() : null).add("VersionNumber", (Object)this.versionNumber()).add("VersionDescription", (Object)this.versionDescription()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerGroupDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.containerGroupDefinitionArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ContainerGroupType": {
                return Optional.ofNullable(clazz.cast(this.containerGroupTypeAsString()));
            }
            case "TotalMemoryLimitMebibytes": {
                return Optional.ofNullable(clazz.cast(this.totalMemoryLimitMebibytes()));
            }
            case "TotalVcpuLimit": {
                return Optional.ofNullable(clazz.cast(this.totalVcpuLimit()));
            }
            case "GameServerContainerDefinition": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerDefinition()));
            }
            case "SupportContainerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.supportContainerDefinitions()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerGroupDefinitionArn", CONTAINER_GROUP_DEFINITION_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ContainerGroupType", CONTAINER_GROUP_TYPE_FIELD);
        map.put("TotalMemoryLimitMebibytes", TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD);
        map.put("TotalVcpuLimit", TOTAL_VCPU_LIMIT_FIELD);
        map.put("GameServerContainerDefinition", GAME_SERVER_CONTAINER_DEFINITION_FIELD);
        map.put("SupportContainerDefinitions", SUPPORT_CONTAINER_DEFINITIONS_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupDefinition, T> g) {
        return obj -> g.apply((ContainerGroupDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerGroupDefinitionArn;
        private Instant creationTime;
        private String operatingSystem;
        private String name;
        private String containerGroupType;
        private Integer totalMemoryLimitMebibytes;
        private Double totalVcpuLimit;
        private GameServerContainerDefinition gameServerContainerDefinition;
        private List<SupportContainerDefinition> supportContainerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Integer versionNumber;
        private String versionDescription;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupDefinition model) {
            this.containerGroupDefinitionArn(model.containerGroupDefinitionArn);
            this.creationTime(model.creationTime);
            this.operatingSystem(model.operatingSystem);
            this.name(model.name);
            this.containerGroupType(model.containerGroupType);
            this.totalMemoryLimitMebibytes(model.totalMemoryLimitMebibytes);
            this.totalVcpuLimit(model.totalVcpuLimit);
            this.gameServerContainerDefinition(model.gameServerContainerDefinition);
            this.supportContainerDefinitions(model.supportContainerDefinitions);
            this.versionNumber(model.versionNumber);
            this.versionDescription(model.versionDescription);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getContainerGroupDefinitionArn() {
            return this.containerGroupDefinitionArn;
        }

        public final void setContainerGroupDefinitionArn(String containerGroupDefinitionArn) {
            this.containerGroupDefinitionArn = containerGroupDefinitionArn;
        }

        @Override
        public final Builder containerGroupDefinitionArn(String containerGroupDefinitionArn) {
            this.containerGroupDefinitionArn = containerGroupDefinitionArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(ContainerOperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getContainerGroupType() {
            return this.containerGroupType;
        }

        public final void setContainerGroupType(String containerGroupType) {
            this.containerGroupType = containerGroupType;
        }

        @Override
        public final Builder containerGroupType(String containerGroupType) {
            this.containerGroupType = containerGroupType;
            return this;
        }

        @Override
        public final Builder containerGroupType(ContainerGroupType containerGroupType) {
            this.containerGroupType(containerGroupType == null ? null : containerGroupType.toString());
            return this;
        }

        public final Integer getTotalMemoryLimitMebibytes() {
            return this.totalMemoryLimitMebibytes;
        }

        public final void setTotalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
        }

        @Override
        public final Builder totalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
            return this;
        }

        public final Double getTotalVcpuLimit() {
            return this.totalVcpuLimit;
        }

        public final void setTotalVcpuLimit(Double totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
        }

        @Override
        public final Builder totalVcpuLimit(Double totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
            return this;
        }

        public final GameServerContainerDefinition.Builder getGameServerContainerDefinition() {
            return this.gameServerContainerDefinition != null ? this.gameServerContainerDefinition.toBuilder() : null;
        }

        public final void setGameServerContainerDefinition(GameServerContainerDefinition.BuilderImpl gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition != null ? gameServerContainerDefinition.build() : null;
        }

        @Override
        public final Builder gameServerContainerDefinition(GameServerContainerDefinition gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition;
            return this;
        }

        public final List<SupportContainerDefinition.Builder> getSupportContainerDefinitions() {
            List<SupportContainerDefinition.Builder> result = SupportContainerDefinitionListCopier.copyToBuilder(this.supportContainerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportContainerDefinitions(Collection<SupportContainerDefinition.BuilderImpl> supportContainerDefinitions) {
            this.supportContainerDefinitions = SupportContainerDefinitionListCopier.copyFromBuilder(supportContainerDefinitions);
        }

        @Override
        public final Builder supportContainerDefinitions(Collection<SupportContainerDefinition> supportContainerDefinitions) {
            this.supportContainerDefinitions = SupportContainerDefinitionListCopier.copy(supportContainerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportContainerDefinitions(SupportContainerDefinition ... supportContainerDefinitions) {
            this.supportContainerDefinitions(Arrays.asList(supportContainerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportContainerDefinitions(Consumer<SupportContainerDefinition.Builder> ... supportContainerDefinitions) {
            this.supportContainerDefinitions(Stream.of(supportContainerDefinitions).map(c -> (SupportContainerDefinition)((SupportContainerDefinition.Builder)SupportContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerGroupDefinitionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public ContainerGroupDefinition build() {
            return new ContainerGroupDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerGroupDefinition> {
        public Builder containerGroupDefinitionArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(ContainerOperatingSystem var1);

        public Builder name(String var1);

        public Builder containerGroupType(String var1);

        public Builder containerGroupType(ContainerGroupType var1);

        public Builder totalMemoryLimitMebibytes(Integer var1);

        public Builder totalVcpuLimit(Double var1);

        public Builder gameServerContainerDefinition(GameServerContainerDefinition var1);

        default public Builder gameServerContainerDefinition(Consumer<GameServerContainerDefinition.Builder> gameServerContainerDefinition) {
            return this.gameServerContainerDefinition((GameServerContainerDefinition)((GameServerContainerDefinition.Builder)GameServerContainerDefinition.builder().applyMutation(gameServerContainerDefinition)).build());
        }

        public Builder supportContainerDefinitions(Collection<SupportContainerDefinition> var1);

        public Builder supportContainerDefinitions(SupportContainerDefinition ... var1);

        public Builder supportContainerDefinitions(Consumer<SupportContainerDefinition.Builder> ... var1);

        public Builder versionNumber(Integer var1);

        public Builder versionDescription(String var1);

        public Builder status(String var1);

        public Builder status(ContainerGroupDefinitionStatus var1);

        public Builder statusReason(String var1);
    }
}

