/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Regional latency information for a player, used when requesting a new game session. This value indicates the amount
 * of time lag that exists when the player is connected to a fleet in the specified Region. The relative difference
 * between a player's latency values for multiple Regions are used to determine which fleets are best suited to place a
 * new game session for the player.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlayerLatency implements SdkPojo, Serializable, ToCopyableBuilder<PlayerLatency.Builder, PlayerLatency> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerId").getter(getter(PlayerLatency::playerId)).setter(setter(Builder::playerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()).build();

    private static final SdkField<String> REGION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionIdentifier").getter(getter(PlayerLatency::regionIdentifier))
            .setter(setter(Builder::regionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionIdentifier").build()).build();

    private static final SdkField<Float> LATENCY_IN_MILLISECONDS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("LatencyInMilliseconds").getter(getter(PlayerLatency::latencyInMilliseconds))
            .setter(setter(Builder::latencyInMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatencyInMilliseconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD,
            REGION_IDENTIFIER_FIELD, LATENCY_IN_MILLISECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String playerId;

    private final String regionIdentifier;

    private final Float latencyInMilliseconds;

    private PlayerLatency(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.regionIdentifier = builder.regionIdentifier;
        this.latencyInMilliseconds = builder.latencyInMilliseconds;
    }

    /**
     * <p>
     * A unique identifier for a player associated with the latency data.
     * </p>
     * 
     * @return A unique identifier for a player associated with the latency data.
     */
    public final String playerId() {
        return playerId;
    }

    /**
     * <p>
     * Name of the Region that is associated with the latency value.
     * </p>
     * 
     * @return Name of the Region that is associated with the latency value.
     */
    public final String regionIdentifier() {
        return regionIdentifier;
    }

    /**
     * <p>
     * Amount of time that represents the time lag experienced by the player when connected to the specified Region.
     * </p>
     * 
     * @return Amount of time that represents the time lag experienced by the player when connected to the specified
     *         Region.
     */
    public final Float latencyInMilliseconds() {
        return latencyInMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(playerId());
        hashCode = 31 * hashCode + Objects.hashCode(regionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(latencyInMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatency)) {
            return false;
        }
        PlayerLatency other = (PlayerLatency) obj;
        return Objects.equals(playerId(), other.playerId()) && Objects.equals(regionIdentifier(), other.regionIdentifier())
                && Objects.equals(latencyInMilliseconds(), other.latencyInMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlayerLatency").add("PlayerId", playerId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RegionIdentifier", regionIdentifier()).add("LatencyInMilliseconds", latencyInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlayerId":
            return Optional.ofNullable(clazz.cast(playerId()));
        case "RegionIdentifier":
            return Optional.ofNullable(clazz.cast(regionIdentifier()));
        case "LatencyInMilliseconds":
            return Optional.ofNullable(clazz.cast(latencyInMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlayerId", PLAYER_ID_FIELD);
        map.put("RegionIdentifier", REGION_IDENTIFIER_FIELD);
        map.put("LatencyInMilliseconds", LATENCY_IN_MILLISECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlayerLatency, T> g) {
        return obj -> g.apply((PlayerLatency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlayerLatency> {
        /**
         * <p>
         * A unique identifier for a player associated with the latency data.
         * </p>
         * 
         * @param playerId
         *        A unique identifier for a player associated with the latency data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerId(String playerId);

        /**
         * <p>
         * Name of the Region that is associated with the latency value.
         * </p>
         * 
         * @param regionIdentifier
         *        Name of the Region that is associated with the latency value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionIdentifier(String regionIdentifier);

        /**
         * <p>
         * Amount of time that represents the time lag experienced by the player when connected to the specified Region.
         * </p>
         * 
         * @param latencyInMilliseconds
         *        Amount of time that represents the time lag experienced by the player when connected to the specified
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latencyInMilliseconds(Float latencyInMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private String playerId;

        private String regionIdentifier;

        private Float latencyInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatency model) {
            playerId(model.playerId);
            regionIdentifier(model.regionIdentifier);
            latencyInMilliseconds(model.latencyInMilliseconds);
        }

        public final String getPlayerId() {
            return playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getRegionIdentifier() {
            return regionIdentifier;
        }

        public final void setRegionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
        }

        @Override
        public final Builder regionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
            return this;
        }

        public final Float getLatencyInMilliseconds() {
            return latencyInMilliseconds;
        }

        public final void setLatencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
        }

        @Override
        public final Builder latencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
            return this;
        }

        @Override
        public PlayerLatency build() {
            return new PlayerLatency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
