/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of fleet locations where a game session queue can place new game sessions. You can use a filter to temporarily
 * exclude specific locations from receiving placements. For queues that have multi-location fleets, you can use a
 * filter configuration allow placement with some, but not all, of a fleet's locations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterConfiguration.Builder, FilterConfiguration> {
    private static final SdkField<List<String>> ALLOWED_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedLocations")
            .getter(getter(FilterConfiguration::allowedLocations))
            .setter(setter(Builder::allowedLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_LOCATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allowedLocations;

    private FilterConfiguration(BuilderImpl builder) {
        this.allowedLocations = builder.allowedLocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedLocations() {
        return allowedLocations != null && !(allowedLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such as
     * <code>us-west-2</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedLocations} method.
     * </p>
     * 
     * @return A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes
     *         such as <code>us-west-2</code>.
     */
    public final List<String> allowedLocations() {
        return allowedLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedLocations() ? allowedLocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterConfiguration)) {
            return false;
        }
        FilterConfiguration other = (FilterConfiguration) obj;
        return hasAllowedLocations() == other.hasAllowedLocations()
                && Objects.equals(allowedLocations(), other.allowedLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterConfiguration").add("AllowedLocations", hasAllowedLocations() ? allowedLocations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedLocations":
            return Optional.ofNullable(clazz.cast(allowedLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowedLocations", ALLOWED_LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterConfiguration, T> g) {
        return obj -> g.apply((FilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterConfiguration> {
        /**
         * <p>
         * A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such
         * as <code>us-west-2</code>.
         * </p>
         * 
         * @param allowedLocations
         *        A list of locations to allow game session placement in, in the form of Amazon Web Services Region
         *        codes such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedLocations(Collection<String> allowedLocations);

        /**
         * <p>
         * A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such
         * as <code>us-west-2</code>.
         * </p>
         * 
         * @param allowedLocations
         *        A list of locations to allow game session placement in, in the form of Amazon Web Services Region
         *        codes such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedLocations(String... allowedLocations);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterConfiguration model) {
            allowedLocations(model.allowedLocations);
        }

        public final Collection<String> getAllowedLocations() {
            if (allowedLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedLocations;
        }

        public final void setAllowedLocations(Collection<String> allowedLocations) {
            this.allowedLocations = LocationListCopier.copy(allowedLocations);
        }

        @Override
        public final Builder allowedLocations(Collection<String> allowedLocations) {
            this.allowedLocations = LocationListCopier.copy(allowedLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedLocations(String... allowedLocations) {
            allowedLocations(Arrays.asList(allowedLocations));
            return this;
        }

        @Override
        public FilterConfiguration build() {
            return new FilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
