/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum EventCode {
    GENERIC_EVENT("GENERIC_EVENT"),

    FLEET_CREATED("FLEET_CREATED"),

    FLEET_DELETED("FLEET_DELETED"),

    FLEET_SCALING_EVENT("FLEET_SCALING_EVENT"),

    FLEET_STATE_DOWNLOADING("FLEET_STATE_DOWNLOADING"),

    FLEET_STATE_VALIDATING("FLEET_STATE_VALIDATING"),

    FLEET_STATE_BUILDING("FLEET_STATE_BUILDING"),

    FLEET_STATE_ACTIVATING("FLEET_STATE_ACTIVATING"),

    FLEET_STATE_ACTIVE("FLEET_STATE_ACTIVE"),

    FLEET_STATE_ERROR("FLEET_STATE_ERROR"),

    FLEET_STATE_PENDING("FLEET_STATE_PENDING"),

    FLEET_STATE_CREATING("FLEET_STATE_CREATING"),

    FLEET_STATE_CREATED("FLEET_STATE_CREATED"),

    FLEET_STATE_UPDATING("FLEET_STATE_UPDATING"),

    FLEET_INITIALIZATION_FAILED("FLEET_INITIALIZATION_FAILED"),

    FLEET_BINARY_DOWNLOAD_FAILED("FLEET_BINARY_DOWNLOAD_FAILED"),

    FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND("FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND"),

    FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE("FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE"),

    FLEET_VALIDATION_TIMED_OUT("FLEET_VALIDATION_TIMED_OUT"),

    FLEET_ACTIVATION_FAILED("FLEET_ACTIVATION_FAILED"),

    FLEET_ACTIVATION_FAILED_NO_INSTANCES("FLEET_ACTIVATION_FAILED_NO_INSTANCES"),

    FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED("FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED"),

    SERVER_PROCESS_INVALID_PATH("SERVER_PROCESS_INVALID_PATH"),

    SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT("SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT"),

    SERVER_PROCESS_PROCESS_READY_TIMEOUT("SERVER_PROCESS_PROCESS_READY_TIMEOUT"),

    SERVER_PROCESS_CRASHED("SERVER_PROCESS_CRASHED"),

    SERVER_PROCESS_TERMINATED_UNHEALTHY("SERVER_PROCESS_TERMINATED_UNHEALTHY"),

    SERVER_PROCESS_FORCE_TERMINATED("SERVER_PROCESS_FORCE_TERMINATED"),

    SERVER_PROCESS_PROCESS_EXIT_TIMEOUT("SERVER_PROCESS_PROCESS_EXIT_TIMEOUT"),

    SERVER_PROCESS_SDK_INITIALIZATION_FAILED("SERVER_PROCESS_SDK_INITIALIZATION_FAILED"),

    SERVER_PROCESS_MISCONFIGURED_CONTAINER_PORT("SERVER_PROCESS_MISCONFIGURED_CONTAINER_PORT"),

    GAME_SESSION_ACTIVATION_TIMEOUT("GAME_SESSION_ACTIVATION_TIMEOUT"),

    FLEET_CREATION_EXTRACTING_BUILD("FLEET_CREATION_EXTRACTING_BUILD"),

    FLEET_CREATION_RUNNING_INSTALLER("FLEET_CREATION_RUNNING_INSTALLER"),

    FLEET_CREATION_VALIDATING_RUNTIME_CONFIG("FLEET_CREATION_VALIDATING_RUNTIME_CONFIG"),

    FLEET_VPC_PEERING_SUCCEEDED("FLEET_VPC_PEERING_SUCCEEDED"),

    FLEET_VPC_PEERING_FAILED("FLEET_VPC_PEERING_FAILED"),

    FLEET_VPC_PEERING_DELETED("FLEET_VPC_PEERING_DELETED"),

    INSTANCE_INTERRUPTED("INSTANCE_INTERRUPTED"),

    INSTANCE_RECYCLED("INSTANCE_RECYCLED"),

    INSTANCE_REPLACED_UNHEALTHY("INSTANCE_REPLACED_UNHEALTHY"),

    FLEET_CREATION_COMPLETED_INSTALLER("FLEET_CREATION_COMPLETED_INSTALLER"),

    FLEET_CREATION_FAILED_INSTALLER("FLEET_CREATION_FAILED_INSTALLER"),

    COMPUTE_LOG_UPLOAD_FAILED("COMPUTE_LOG_UPLOAD_FAILED"),

    GAME_SERVER_CONTAINER_GROUP_CRASHED("GAME_SERVER_CONTAINER_GROUP_CRASHED"),

    PER_INSTANCE_CONTAINER_GROUP_CRASHED("PER_INSTANCE_CONTAINER_GROUP_CRASHED"),

    GAME_SERVER_CONTAINER_GROUP_REPLACED_UNHEALTHY("GAME_SERVER_CONTAINER_GROUP_REPLACED_UNHEALTHY"),

    LOCATION_STATE_PENDING("LOCATION_STATE_PENDING"),

    LOCATION_STATE_CREATING("LOCATION_STATE_CREATING"),

    LOCATION_STATE_CREATED("LOCATION_STATE_CREATED"),

    LOCATION_STATE_ACTIVATING("LOCATION_STATE_ACTIVATING"),

    LOCATION_STATE_ACTIVE("LOCATION_STATE_ACTIVE"),

    LOCATION_STATE_UPDATING("LOCATION_STATE_UPDATING"),

    LOCATION_STATE_ERROR("LOCATION_STATE_ERROR"),

    LOCATION_STATE_DELETING("LOCATION_STATE_DELETING"),

    LOCATION_STATE_DELETED("LOCATION_STATE_DELETED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventCode> VALUE_MAP = EnumUtils.uniqueIndex(EventCode.class, EventCode::toString);

    private final String value;

    private EventCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EventCode corresponding to the value
     */
    public static EventCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EventCode}s
     */
    public static Set<EventCode> knownValues() {
        Set<EventCode> knownValues = EnumSet.allOf(EventCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
