/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resource capacity settings. Fleet capacity is measured in Amazon EC2 instances. Pending and terminating counts are
 * non-zero when the fleet capacity is adjusting to a scaling event or if access to resources is temporarily affected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2InstanceCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2InstanceCounts.Builder, EC2InstanceCounts> {
    private static final SdkField<Integer> DESIRED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DESIRED").getter(getter(EC2InstanceCounts::desired)).setter(setter(Builder::desired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DESIRED").build()).build();

    private static final SdkField<Integer> MINIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MINIMUM").getter(getter(EC2InstanceCounts::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MINIMUM").build()).build();

    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MAXIMUM").getter(getter(EC2InstanceCounts::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MAXIMUM").build()).build();

    private static final SdkField<Integer> PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PENDING").getter(getter(EC2InstanceCounts::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PENDING").build()).build();

    private static final SdkField<Integer> ACTIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ACTIVE").getter(getter(EC2InstanceCounts::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACTIVE").build()).build();

    private static final SdkField<Integer> IDLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("IDLE")
            .getter(getter(EC2InstanceCounts::idle)).setter(setter(Builder::idle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IDLE").build()).build();

    private static final SdkField<Integer> TERMINATING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TERMINATING").getter(getter(EC2InstanceCounts::terminating)).setter(setter(Builder::terminating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TERMINATING").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_FIELD, MINIMUM_FIELD,
            MAXIMUM_FIELD, PENDING_FIELD, ACTIVE_FIELD, IDLE_FIELD, TERMINATING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer desired;

    private final Integer minimum;

    private final Integer maximum;

    private final Integer pending;

    private final Integer active;

    private final Integer idle;

    private final Integer terminating;

    private EC2InstanceCounts(BuilderImpl builder) {
        this.desired = builder.desired;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.pending = builder.pending;
        this.active = builder.active;
        this.idle = builder.idle;
        this.terminating = builder.terminating;
    }

    /**
     * <p>
     * Requested number of active instances. Amazon GameLift takes action as needed to maintain the desired number of
     * instances. Capacity is scaled up or down by changing the desired instances. A change in the desired instances
     * value can take up to 1 minute to be reflected when viewing a fleet's capacity settings.
     * </p>
     * 
     * @return Requested number of active instances. Amazon GameLift takes action as needed to maintain the desired
     *         number of instances. Capacity is scaled up or down by changing the desired instances. A change in the
     *         desired instances value can take up to 1 minute to be reflected when viewing a fleet's capacity settings.
     */
    public final Integer desired() {
        return desired;
    }

    /**
     * <p>
     * The minimum instance count value allowed.
     * </p>
     * 
     * @return The minimum instance count value allowed.
     */
    public final Integer minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum instance count value allowed.
     * </p>
     * 
     * @return The maximum instance count value allowed.
     */
    public final Integer maximum() {
        return maximum;
    }

    /**
     * <p>
     * Number of instances that are starting but not yet active.
     * </p>
     * 
     * @return Number of instances that are starting but not yet active.
     */
    public final Integer pending() {
        return pending;
    }

    /**
     * <p>
     * Actual number of instances that are ready to host game sessions.
     * </p>
     * 
     * @return Actual number of instances that are ready to host game sessions.
     */
    public final Integer active() {
        return active;
    }

    /**
     * <p>
     * Number of active instances that are not currently hosting a game session.
     * </p>
     * 
     * @return Number of active instances that are not currently hosting a game session.
     */
    public final Integer idle() {
        return idle;
    }

    /**
     * <p>
     * Number of instances that are no longer active but haven't yet been terminated.
     * </p>
     * 
     * @return Number of instances that are no longer active but haven't yet been terminated.
     */
    public final Integer terminating() {
        return terminating;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desired());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(idle());
        hashCode = 31 * hashCode + Objects.hashCode(terminating());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceCounts)) {
            return false;
        }
        EC2InstanceCounts other = (EC2InstanceCounts) obj;
        return Objects.equals(desired(), other.desired()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(maximum(), other.maximum()) && Objects.equals(pending(), other.pending())
                && Objects.equals(active(), other.active()) && Objects.equals(idle(), other.idle())
                && Objects.equals(terminating(), other.terminating());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2InstanceCounts").add("DESIRED", desired()).add("MINIMUM", minimum())
                .add("MAXIMUM", maximum()).add("PENDING", pending()).add("ACTIVE", active()).add("IDLE", idle())
                .add("TERMINATING", terminating()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DESIRED":
            return Optional.ofNullable(clazz.cast(desired()));
        case "MINIMUM":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "MAXIMUM":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "PENDING":
            return Optional.ofNullable(clazz.cast(pending()));
        case "ACTIVE":
            return Optional.ofNullable(clazz.cast(active()));
        case "IDLE":
            return Optional.ofNullable(clazz.cast(idle()));
        case "TERMINATING":
            return Optional.ofNullable(clazz.cast(terminating()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DESIRED", DESIRED_FIELD);
        map.put("MINIMUM", MINIMUM_FIELD);
        map.put("MAXIMUM", MAXIMUM_FIELD);
        map.put("PENDING", PENDING_FIELD);
        map.put("ACTIVE", ACTIVE_FIELD);
        map.put("IDLE", IDLE_FIELD);
        map.put("TERMINATING", TERMINATING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceCounts, T> g) {
        return obj -> g.apply((EC2InstanceCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2InstanceCounts> {
        /**
         * <p>
         * Requested number of active instances. Amazon GameLift takes action as needed to maintain the desired number
         * of instances. Capacity is scaled up or down by changing the desired instances. A change in the desired
         * instances value can take up to 1 minute to be reflected when viewing a fleet's capacity settings.
         * </p>
         * 
         * @param desired
         *        Requested number of active instances. Amazon GameLift takes action as needed to maintain the desired
         *        number of instances. Capacity is scaled up or down by changing the desired instances. A change in the
         *        desired instances value can take up to 1 minute to be reflected when viewing a fleet's capacity
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desired(Integer desired);

        /**
         * <p>
         * The minimum instance count value allowed.
         * </p>
         * 
         * @param minimum
         *        The minimum instance count value allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Integer minimum);

        /**
         * <p>
         * The maximum instance count value allowed.
         * </p>
         * 
         * @param maximum
         *        The maximum instance count value allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Integer maximum);

        /**
         * <p>
         * Number of instances that are starting but not yet active.
         * </p>
         * 
         * @param pending
         *        Number of instances that are starting but not yet active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * Actual number of instances that are ready to host game sessions.
         * </p>
         * 
         * @param active
         *        Actual number of instances that are ready to host game sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Integer active);

        /**
         * <p>
         * Number of active instances that are not currently hosting a game session.
         * </p>
         * 
         * @param idle
         *        Number of active instances that are not currently hosting a game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idle(Integer idle);

        /**
         * <p>
         * Number of instances that are no longer active but haven't yet been terminated.
         * </p>
         * 
         * @param terminating
         *        Number of instances that are no longer active but haven't yet been terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminating(Integer terminating);
    }

    static final class BuilderImpl implements Builder {
        private Integer desired;

        private Integer minimum;

        private Integer maximum;

        private Integer pending;

        private Integer active;

        private Integer idle;

        private Integer terminating;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceCounts model) {
            desired(model.desired);
            minimum(model.minimum);
            maximum(model.maximum);
            pending(model.pending);
            active(model.active);
            idle(model.idle);
            terminating(model.terminating);
        }

        public final Integer getDesired() {
            return desired;
        }

        public final void setDesired(Integer desired) {
            this.desired = desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final Integer getMinimum() {
            return minimum;
        }

        public final void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Integer getMaximum() {
            return maximum;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Integer getPending() {
            return pending;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final Integer getActive() {
            return active;
        }

        public final void setActive(Integer active) {
            this.active = active;
        }

        @Override
        public final Builder active(Integer active) {
            this.active = active;
            return this;
        }

        public final Integer getIdle() {
            return idle;
        }

        public final void setIdle(Integer idle) {
            this.idle = idle;
        }

        @Override
        public final Builder idle(Integer idle) {
            this.idle = idle;
            return this;
        }

        public final Integer getTerminating() {
            return terminating;
        }

        public final void setTerminating(Integer terminating) {
            this.terminating = terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        @Override
        public EC2InstanceCounts build() {
            return new EC2InstanceCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
